/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.components;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class TextAreaOutputStream
extends ByteArrayOutputStream {
    private final String EOL = System.getProperty("line.separator");
    private final StringBuffer buffer = new StringBuffer(80);
    private final JTextArea textArea;
    private final Document document;
    private final SimpleAttributeSet attributes;

    public TextAreaOutputStream(JTextArea output) {
        this.textArea = output;
        this.document = output.getDocument();
        this.attributes = new SimpleAttributeSet();
    }

    public TextAreaOutputStream(JTextArea output, Color color) {
        this(output);
        StyleConstants.setForeground(this.attributes, color);
    }

    @Override
    public void flush() {
        String message = this.toString();
        if (message.isEmpty()) {
            return;
        }
        message = message.replaceAll("\u001b\\[[;\\d]*m", "");
        this.append(message);
        this.reset();
    }

    private void append(String message) {
        if (this.document.getLength() == 0) {
            this.buffer.setLength(0);
        }
        if (this.EOL.equals(message)) {
            this.buffer.append(message);
        } else {
            this.buffer.append(message);
            this.writeBuffer();
        }
    }

    private void writeBuffer() {
        try {
            int offset = this.document.getLength();
            this.document.insertString(offset, this.buffer.toString(), this.attributes);
            this.textArea.setCaretPosition(this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.buffer.setLength(0);
    }
}

