/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.modals;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import org.spigotmc.gui.Theme;
import org.spigotmc.gui.attributes.Themeable;
import org.spigotmc.gui.data.ThemePack;
import org.spigotmc.utils.Constants;
import org.spigotmc.utils.SwingUtils;

public class MessageModal
extends JFrame
implements Themeable {
    private JTextPane messagePane;
    private final ImageIcon icon;
    private final String labelText;

    protected MessageModal(String title, ImageIcon icon, String labelText, String message) {
        this.icon = icon;
        this.labelText = labelText;
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setSize(new Dimension(600, 500));
        SwingUtils.applyIcon(this);
        this.initComponents();
        this.messagePane.setText(message);
        this.messagePane.setCaretPosition(0);
        SwingUtils.changeTheme(this, SwingUtils.getTheme());
    }

    protected void initComponents() {
        JScrollPane messageScrollPane = new JScrollPane();
        this.messagePane = new JTextPane();
        this.messagePane.setEditable(false);
        this.messagePane.setContentType("text/html");
        this.messagePane.addHyperlinkListener(this::hyperLinkClick);
        messageScrollPane.setViewportView(this.messagePane);
        JLabel label = new JLabel(this.labelText);
        label.setIcon(this.icon);
        label.setIconTextGap(12);
        JPanel labelPanel = new JPanel();
        GroupLayout labelLayout = new GroupLayout(labelPanel);
        labelPanel.setLayout(labelLayout);
        labelLayout.setHorizontalGroup(labelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(labelLayout.createSequentialGroup().addContainerGap().addComponent(label).addContainerGap(492, Short.MAX_VALUE)));
        labelLayout.setVerticalGroup(labelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, labelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(label)));
        JButton closeButton = new JButton("Close");
        closeButton.setMargin(new Insets(8, 16, 8, 16));
        closeButton.addActionListener(this::closeButtonActionPerformed);
        JPanel buttonPanel = new JPanel();
        GroupLayout buttonLayout = new GroupLayout(buttonPanel);
        buttonPanel.setLayout(buttonLayout);
        buttonLayout.setHorizontalGroup(buttonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(closeButton).addContainerGap(-1, Short.MAX_VALUE)));
        buttonLayout.setVerticalGroup(buttonLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(closeButton, -1, -1, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(labelPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(messageScrollPane).addComponent(buttonPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(labelPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(messageScrollPane, -2, 397, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(buttonPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void hyperLinkClick(HyperlinkEvent event) {
        if (!HyperlinkEvent.EventType.ACTIVATED.equals(event.getEventType())) {
            return;
        }
        String url = event.getURL().toString();
        if (url.startsWith("file:/")) {
            SwingUtils.open(url.replace("file:", ""));
        } else {
            SwingUtils.browse(event.getURL().toString());
        }
    }

    private void closeButtonActionPerformed(ActionEvent event) {
        this.dispose();
    }

    @Override
    public void onThemeChange(Theme theme) {
        ThemePack pack = ThemePack.fromTheme(theme);
        String lookAndFeelClass = (String)pack.getAsset(ThemePack.Asset.LOOK_AND_FEEL_CLASS);
        UIManager.setLookAndFeel(lookAndFeelClass);
        SwingUtilities.updateComponentTreeUI(this);
    }

    public static void displayError(String message) {
        MessageModal.displayMessage("Error", Constants.ERROR, message);
    }

    public static void displayWarning(String message) {
        MessageModal.displayMessage("Warning", Constants.WARNING, message);
    }

    public static void displaySuccess(String message) {
        MessageModal.displayMessage("Success", Constants.SUCCESS, message);
    }

    private static void displayMessage(String title, ImageIcon icon, String message) {
        MessageModal modal = new MessageModal("BuildTools " + title, icon, title.toUpperCase(), message);
        modal.setLocationRelativeTo(null);
        modal.setVisible(true);
    }
}

