/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.IEssentials;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.ess3.provider.KnownCommandsProvider;
import org.bukkit.command.Command;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;

public class AlternativeCommandsHandler {
    private final transient Map<String, List<WeakReference<Command>>> altCommands = new HashMap<String, List<WeakReference<Command>>>();
    private final transient Map<String, String> disabledList = new HashMap<String, String>();
    private final transient IEssentials ess;

    public AlternativeCommandsHandler(IEssentials ess) {
        this.ess = ess;
        for (Plugin plugin : ess.getServer().getPluginManager().getPlugins()) {
            if (!plugin.isEnabled()) continue;
            this.addPlugin(plugin);
        }
    }

    public final void addPlugin(Plugin plugin) {
        if (plugin.getDescription().getMain().contains("com.earth2me.essentials") || plugin.getDescription().getMain().contains("net.essentialsx")) {
            return;
        }
        for (Map.Entry<String, Command> entry : this.getPluginCommands(plugin)) {
            String[] commandSplit = entry.getKey().split(":", 2);
            String commandName = commandSplit.length > 1 ? commandSplit[1] : entry.getKey();
            Command command = entry.getValue();
            List pluginCommands = this.altCommands.computeIfAbsent(commandName.toLowerCase(Locale.ENGLISH), k -> new ArrayList());
            boolean found = false;
            Iterator pluginCmdIterator = pluginCommands.iterator();
            while (pluginCmdIterator.hasNext()) {
                Command cmd = (Command)((WeakReference)pluginCmdIterator.next()).get();
                if (cmd == null) {
                    if (this.ess.getSettings().isDebug()) {
                        this.ess.getLogger().log(Level.INFO, "Essentials: Alternative command for " + commandName + " removed due to garbage collection");
                    }
                    pluginCmdIterator.remove();
                    continue;
                }
                if (!((PluginIdentifiableCommand)cmd).getPlugin().equals((Object)plugin)) continue;
                found = true;
                break;
            }
            if (found) continue;
            pluginCommands.add(new WeakReference<Command>(command));
        }
    }

    private List<Map.Entry<String, Command>> getPluginCommands(Plugin plugin) {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        for (Map.Entry<String, Command> entry : this.ess.provider(KnownCommandsProvider.class).getKnownCommands().entrySet()) {
            if (!(entry.getValue() instanceof PluginIdentifiableCommand) || !((PluginIdentifiableCommand)entry.getValue()).getPlugin().equals((Object)plugin)) continue;
            commands.put(entry.getKey(), entry.getValue());
        }
        return commands.entrySet().stream().sorted((o1, o2) -> {
            if (((String)o1.getKey()).contains(":") && !((String)o2.getKey()).contains(":")) {
                return 1;
            }
            if (!((String)o1.getKey()).contains(":") && ((String)o2.getKey()).contains(":")) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    public void removePlugin(Plugin plugin) {
        Iterator<Map.Entry<String, List<WeakReference<Command>>>> iterator = this.altCommands.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<WeakReference<Command>>> entry = iterator.next();
            Iterator<WeakReference<Command>> commands = entry.getValue().iterator();
            while (commands.hasNext()) {
                Command pc = (Command)commands.next().get();
                if (pc instanceof PluginIdentifiableCommand && !((PluginIdentifiableCommand)pc).getPlugin().equals((Object)plugin)) continue;
                commands.remove();
            }
            if (!entry.getValue().isEmpty()) continue;
            iterator.remove();
        }
    }

    public Command getAlternative(String label) {
        List<WeakReference<Command>> commands = this.altCommands.get(label);
        if (commands == null || commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0).get();
        }
        Iterator<WeakReference<Command>> iterator = commands.iterator();
        while (iterator.hasNext()) {
            Command cmd = (Command)iterator.next().get();
            if (cmd == null) {
                iterator.remove();
                continue;
            }
            if (!cmd.getName().equalsIgnoreCase(label)) continue;
            return cmd;
        }
        return (Command)commands.get(0).get();
    }

    public void executed(String label, Command pc) {
        if (pc instanceof PluginIdentifiableCommand) {
            String altString = ((PluginIdentifiableCommand)pc).getPlugin().getName() + ":" + pc.getName();
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.INFO, "Essentials: Alternative command " + label + " found, using " + altString);
            }
            this.disabledList.put(label, altString);
        }
    }

    public Map<String, String> disabledCommands() {
        return this.disabledList;
    }
}

