/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.utils.AdventureUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import net.ess3.api.II18n;
import org.jetbrains.annotations.NotNull;

public class I18n
implements II18n {
    private static final String MESSAGES = "messages";
    private static final Pattern NODOUBLEMARK = Pattern.compile("''");
    private static final ExecutorService BUNDLE_LOADER_EXECUTOR = Executors.newFixedThreadPool(2);
    private static final ResourceBundle NULL_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(@NotNull String key) {
            return null;
        }
    };
    private static I18n instance;
    private final transient Locale defaultLocale;
    private final transient ResourceBundle defaultBundle;
    private final transient IEssentials ess;
    private transient Locale currentLocale;
    private final transient Map<Locale, ResourceBundle> loadedBundles;
    private final transient List<Locale> loadingBundles;
    private transient ResourceBundle localeBundle;
    private final transient Map<Locale, Map<String, MessageFormat>> messageFormatCache;

    public I18n(IEssentials ess) {
        this.currentLocale = this.defaultLocale = Locale.getDefault();
        this.loadedBundles = new ConcurrentHashMap<Locale, ResourceBundle>();
        this.loadingBundles = new ArrayList<Locale>();
        this.messageFormatCache = new HashMap<Locale, Map<String, MessageFormat>>();
        this.ess = ess;
        this.localeBundle = this.defaultBundle = ResourceBundle.getBundle(MESSAGES, Locale.ENGLISH, new UTF8PropertiesControl());
    }

    public static String tlLiteral(String tlKey, Object ... objects) {
        if (instance == null) {
            return "";
        }
        return I18n.tlLocale(I18n.instance.currentLocale, tlKey, objects);
    }

    public static String tlLocale(Locale locale, String tlKey, Object ... objects) {
        if (instance == null) {
            return "";
        }
        if (objects.length == 0) {
            return NODOUBLEMARK.matcher(instance.translate(locale, tlKey)).replaceAll("'");
        }
        return instance.format(locale, tlKey, objects);
    }

    public static String capitalCase(String input) {
        return input == null || input.isEmpty() ? input : input.toUpperCase(Locale.ENGLISH).charAt(0) + input.toLowerCase(Locale.ENGLISH).substring(1);
    }

    public void onEnable() {
        instance = this;
    }

    public void onDisable() {
        instance = null;
    }

    @Override
    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getBundle(Locale locale) {
        if (this.loadedBundles.containsKey(locale)) {
            return this.loadedBundles.get(locale);
        }
        List<Locale> list = this.loadingBundles;
        synchronized (list) {
            if (!this.loadingBundles.contains(locale)) {
                this.loadingBundles.add(locale);
                BUNDLE_LOADER_EXECUTOR.submit(() -> {
                    ResourceBundle bundle;
                    try {
                        bundle = ResourceBundle.getBundle(MESSAGES, locale, new FileResClassLoader(I18n.class.getClassLoader(), this.ess), new UTF8PropertiesControl());
                    }
                    catch (MissingResourceException ex) {
                        try {
                            bundle = ResourceBundle.getBundle(MESSAGES, locale, new UTF8PropertiesControl());
                        }
                        catch (MissingResourceException ex2) {
                            bundle = NULL_BUNDLE;
                        }
                    }
                    this.loadedBundles.put(locale, bundle);
                    List<Locale> list = this.loadingBundles;
                    synchronized (list) {
                        this.loadingBundles.remove(locale);
                    }
                });
            }
        }
        return this.defaultBundle;
    }

    private String translate(Locale locale, String string) {
        try {
            return this.getBundle(locale).getString(string);
        }
        catch (MissingResourceException ex) {
            try {
                return this.localeBundle.getString(string);
            }
            catch (MissingResourceException ex2) {
                if (this.ess != null && this.ess.getSettings().isDebug()) {
                    this.ess.getLogger().log(Level.WARNING, String.format("Missing translation key \"%s\" in translation file %s", ex2.getKey(), this.localeBundle.getLocale().toString()), ex2);
                }
                return this.defaultBundle.getString(string);
            }
        }
    }

    private String format(Locale locale, String string, Object ... objects) {
        String format = this.translate(locale, string);
        MessageFormat messageFormat = (MessageFormat)this.messageFormatCache.computeIfAbsent(locale, l -> new HashMap()).get(format);
        if (messageFormat == null) {
            try {
                messageFormat = new MessageFormat(format);
            }
            catch (IllegalArgumentException e) {
                this.ess.getLogger().log(Level.SEVERE, "Invalid Translation key for '" + string + "': " + e.getMessage());
                format = format.replaceAll("\\{(\\D*?)}", "\\[$1\\]");
                messageFormat = new MessageFormat(format);
            }
            this.messageFormatCache.get(locale).put(format, messageFormat);
        }
        Object[] processedArgs = I18n.mutateArgs(objects, arg -> {
            if (arg instanceof AdventureUtil.ParsedPlaceholder) {
                return arg.toString();
            }
            return AdventureUtil.legacyToMini(AdventureUtil.miniMessage().escapeTags(arg.toString()));
        });
        return messageFormat.format(processedArgs).replace('\u00a0', ' ');
    }

    public static Object[] mutateArgs(Object[] objects, Function<Object, String> mutator) {
        Object[] args = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            args[i] = object instanceof Number || object instanceof Date || object == null ? object : mutator.apply(object);
        }
        return args;
    }

    public void updateLocale(String loc) {
        if (loc != null && !loc.isEmpty()) {
            this.currentLocale = I18n.getLocale(loc);
        }
        ResourceBundle.clearCache();
        this.loadedBundles.clear();
        this.messageFormatCache.clear();
        this.ess.getLogger().log(Level.INFO, String.format("Using locale %s", this.currentLocale.toString()));
        try {
            this.localeBundle = ResourceBundle.getBundle(MESSAGES, this.currentLocale, new UTF8PropertiesControl());
        }
        catch (MissingResourceException ex) {
            this.localeBundle = NULL_BUNDLE;
        }
    }

    public static Locale getLocale(String loc) {
        if (loc == null || loc.isEmpty()) {
            return I18n.instance.currentLocale;
        }
        String[] parts = loc.split("[_.]");
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        return I18n.instance.currentLocale;
    }

    private static final class UTF8PropertiesControl
    extends ResourceBundle.Control {
        private UTF8PropertiesControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    private static class FileResClassLoader
    extends ClassLoader {
        private final transient File messagesFolder;

        FileResClassLoader(ClassLoader classLoader, IEssentials ess) {
            super(classLoader);
            this.messagesFolder = new File(ess.getDataFolder(), I18n.MESSAGES);
            this.messagesFolder.mkdirs();
        }

        @Override
        public URL getResource(String string) {
            File file = new File(this.messagesFolder, string);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            File file = new File(this.messagesFolder, string);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

