/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.config.ConfigurateUtil;
import com.earth2me.essentials.config.EssentialsConfiguration;
import com.earth2me.essentials.config.entities.LazyLocation;
import com.earth2me.essentials.libs.configurate.CommentedConfigurationNode;
import com.earth2me.essentials.paperlib.PaperLib;
import com.earth2me.essentials.utils.LocationUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.ess3.provider.BiomeKeyProvider;
import net.ess3.provider.BiomeNameProvider;
import net.ess3.provider.WorldInfoProvider;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class RandomTeleport
implements IConf {
    private static final Random RANDOM = new Random();
    private static final int HIGHEST_BLOCK_Y_OFFSET = VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_15_R01) ? 1 : 0;
    private final IEssentials ess;
    private final EssentialsConfiguration config;
    private final Map<String, ConcurrentLinkedQueue<Location>> cachedLocations = new HashMap<String, ConcurrentLinkedQueue<Location>>();
    private WorldInfoProvider worldInfoProvider;

    public RandomTeleport(IEssentials essentials) {
        this.ess = essentials;
        this.config = new EssentialsConfiguration(new File(essentials.getDataFolder(), "tpr.yml"), "/tpr.yml", "Configuration for the random teleport command.\nUse the /settpr command in-game to set random teleport locations.");
    }

    public EssentialsConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void reloadConfig() {
        this.worldInfoProvider = this.ess.provider(WorldInfoProvider.class);
        this.config.load();
        this.cachedLocations.clear();
    }

    public boolean hasLocation(String name) {
        return this.config.hasProperty("locations." + name);
    }

    public Location getCenter(String name) {
        LazyLocation center = this.config.getLocation(this.locationKey(name, "center"));
        if (center != null && center.location() != null) {
            return center.location();
        }
        Location worldCenter = ((World)this.ess.getServer().getWorlds().get(0)).getWorldBorder().getCenter();
        worldCenter.setY((double)(worldCenter.getWorld().getHighestBlockYAt(worldCenter) + HIGHEST_BLOCK_Y_OFFSET));
        this.setCenter(name, worldCenter);
        return worldCenter;
    }

    public void setCenter(String name, Location center) {
        this.config.setProperty(this.locationKey(name, "center"), center);
        this.config.save();
    }

    public double getMinRange(String name) {
        return this.config.getDouble(this.locationKey(name, "min-range"), 0.0);
    }

    public void setMinRange(String name, double minRange) {
        this.config.setProperty(this.locationKey(name, "min-range"), minRange);
        this.config.save();
    }

    public double getMaxRange(String name) {
        return this.config.getDouble(this.locationKey(name, "max-range"), this.getCenter(name).getWorld().getWorldBorder().getSize() / 2.0);
    }

    public void setMaxRange(String name, double maxRange) {
        this.config.setProperty(this.locationKey(name, "max-range"), maxRange);
        this.config.save();
    }

    public String getDefaultLocation() {
        return this.config.getString("default-location", "{world}");
    }

    public boolean isPerLocationPermission() {
        return this.config.getBoolean("per-location-permission", false);
    }

    public Set<String> getExcludedBiomes() {
        HashSet<String> excludedBiomes = new HashSet<String>();
        for (String key : this.config.getList("excluded-biomes", String.class)) {
            excludedBiomes.add(key.toLowerCase());
        }
        return excludedBiomes;
    }

    public int getFindAttempts() {
        return this.config.getInt("find-attempts", 10);
    }

    public int getCacheThreshold() {
        return this.config.getInt("cache-threshold", 10);
    }

    public List<String> listLocations() {
        return new ArrayList<String>(ConfigurateUtil.getKeys((CommentedConfigurationNode)this.config.getRootNode().node(new Object[]{"locations"})));
    }

    public Queue<Location> getCachedLocations(String name) {
        this.cachedLocations.computeIfAbsent(name, x -> new ConcurrentLinkedQueue());
        return this.cachedLocations.get(name);
    }

    public CompletableFuture<Location> getRandomLocation(String name) {
        Queue<Location> cached = this.getCachedLocations(name);
        if (cached.size() < this.getCacheThreshold()) {
            this.cacheRandomLocations(name);
        }
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        if (cached.isEmpty()) {
            int findAttempts = this.getFindAttempts();
            Location center = this.getCenter(name);
            double minRange = this.getMinRange(name);
            double maxRange = this.getMaxRange(name);
            this.attemptRandomLocation(findAttempts, center, minRange, maxRange).thenAccept(future::complete);
        } else {
            future.complete(cached.poll());
        }
        return future;
    }

    public CompletableFuture<Location> getRandomLocation(Location center, double minRange, double maxRange) {
        return this.attemptRandomLocation(this.getFindAttempts(), center, minRange, maxRange);
    }

    public void cacheRandomLocations(String name) {
        this.ess.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.ess, () -> {
            for (int i = 0; i < this.getFindAttempts(); ++i) {
                this.calculateRandomLocation(this.getCenter(name), this.getMinRange(name), this.getMaxRange(name)).thenAccept(location -> {
                    if (this.isValidRandomLocation((Location)location)) {
                        this.getCachedLocations(name).add((Location)location);
                    }
                });
            }
        });
    }

    private CompletableFuture<Location> attemptRandomLocation(int attempts, Location center, double minRange, double maxRange) {
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        if (attempts > 0) {
            this.calculateRandomLocation(center, minRange, maxRange).thenAccept(location -> {
                if (this.isValidRandomLocation((Location)location)) {
                    future.complete((Location)location);
                } else {
                    this.attemptRandomLocation(attempts - 1, center, minRange, maxRange).thenAccept(future::complete);
                }
            });
        } else {
            future.complete(center);
        }
        return future;
    }

    private CompletableFuture<Location> calculateRandomLocation(Location center, double minRange, double maxRange) {
        double offsetZ;
        double offsetX;
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        double rectX = RANDOM.nextDouble() * (maxRange - minRange) + minRange;
        double rectZ = RANDOM.nextDouble() * (maxRange + minRange) - minRange;
        int transform = RANDOM.nextInt(4);
        if (transform == 0) {
            offsetX = rectX;
            offsetZ = rectZ;
        } else if (transform == 1) {
            offsetX = -rectZ;
            offsetZ = rectX;
        } else if (transform == 2) {
            offsetX = -rectX;
            offsetZ = -rectZ;
        } else {
            offsetX = rectZ;
            offsetZ = -rectX;
        }
        Location location = new Location(center.getWorld(), center.getX() + offsetX, (double)this.worldInfoProvider.getMaxHeight(center.getWorld()), center.getZ() + offsetZ, 360.0f * RANDOM.nextFloat() - 180.0f, 0.0f);
        PaperLib.getChunkAtAsync(location).thenAccept(chunk -> {
            if (World.Environment.NETHER.equals((Object)center.getWorld().getEnvironment())) {
                location.setY(this.getNetherYAt(location));
            } else {
                location.setY((double)(center.getWorld().getHighestBlockYAt(location) + HIGHEST_BLOCK_Y_OFFSET));
            }
            future.complete(location);
        });
        return future;
    }

    private double getNetherYAt(Location location) {
        World world = location.getWorld();
        for (int y = 32; y < this.worldInfoProvider.getMaxHeight(world) && !Material.BEDROCK.equals((Object)world.getBlockAt(location.getBlockX(), y, location.getBlockZ()).getType()); ++y) {
            if (LocationUtil.isBlockUnsafe(this.ess, world, location.getBlockX(), y, location.getBlockZ())) continue;
            return y;
        }
        return Double.MIN_VALUE;
    }

    private boolean isValidRandomLocation(Location location) {
        return location.getBlockY() > this.worldInfoProvider.getMinHeight(location.getWorld()) && !this.isExcludedBiome(location);
    }

    private boolean isExcludedBiome(Location location) {
        String enumKey;
        BiomeNameProvider biomeNameProvider = this.ess.provider(BiomeNameProvider.class);
        Set<String> excluded = this.getExcludedBiomes();
        if (excluded.contains(enumKey = biomeNameProvider.getBiomeName(location.getBlock()))) {
            return true;
        }
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_4_R01)) {
            return false;
        }
        BiomeKeyProvider biomeKeyProvider = this.ess.provider(BiomeKeyProvider.class);
        String biomeKey = biomeKeyProvider != null ? biomeKeyProvider.getBiomeKey(location.getBlock()).toString() : location.getBlock().getBiome().getKey().toString();
        return excluded.contains(biomeKey);
    }

    private String locationKey(String name, String key) {
        return "locations." + name + "." + key;
    }

    public File getFile() {
        return this.config.getFile();
    }
}

