/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerExemptException;
import com.earth2me.essentials.commands.QuietAbortException;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class Commandfeed
extends EssentialsLoopCommand {
    public Commandfeed() {
        super("feed");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (!user.isAuthorized("essentials.feed.cooldown.bypass")) {
            user.healCooldown();
        }
        if (args.length > 0 && user.isAuthorized("essentials.feed.others")) {
            this.loopOnlinePlayers(server, user.getSource(), true, true, args[0], null);
            return;
        }
        this.feedPlayer(user.getBase());
        user.sendTl("feed", new Object[0]);
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        this.loopOnlinePlayers(server, sender, true, true, args[0], null);
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User player, String[] args) throws PlayerExemptException {
        try {
            this.feedPlayer(player.getBase());
            sender.sendTl("feedOther", player.getDisplayName());
        }
        catch (QuietAbortException quietAbortException) {
            // empty catch block
        }
    }

    private void feedPlayer(Player player) throws QuietAbortException {
        int amount = 30;
        FoodLevelChangeEvent flce = new FoodLevelChangeEvent((HumanEntity)player, 30);
        this.ess.getServer().getPluginManager().callEvent((Event)flce);
        if (flce.isCancelled()) {
            throw new QuietAbortException();
        }
        player.setFoodLevel(Math.min(flce.getFoodLevel(), 20));
        player.setSaturation(10.0f);
        player.setExhaustion(0.0f);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1 && sender.isAuthorized("essentials.feed.others")) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

