/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.messaging.IMessageRecipient;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.ess3.api.IUser;
import net.essentialsx.api.v2.events.HelpopMessageSendEvent;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commandhelpop
extends EssentialsCommand {
    public Commandhelpop() {
        super("helpop");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        user.setDisplayNick();
        this.sendMessage(user, args);
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        this.sendMessage(Console.getInstance(), args);
    }

    private void sendMessage(IMessageRecipient from, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        String message = FormatUtil.stripFormat(Commandhelpop.getFinalArg(args, 0));
        this.ess.getLogger().log(Level.INFO, AdventureUtil.miniToLegacy(I18n.tlLiteral("helpOp", from.getDisplayName(), message)));
        ArrayList<IUser> recipients = new ArrayList<IUser>();
        for (IUser iUser : this.ess.getOnlineUsers()) {
            if (!iUser.isAuthorized("essentials.helpop.receive")) continue;
            recipients.add(iUser);
        }
        HelpopMessageSendEvent sendEvent = new HelpopMessageSendEvent(from, recipients, message);
        this.ess.getServer().getPluginManager().callEvent((Event)sendEvent);
        IUser iUser = (IUser)((Object)from);
        if (!recipients.contains(iUser)) {
            from.sendTl("helpOp", from.getDisplayName(), message);
        }
        for (IUser recipient : sendEvent.getRecipients()) {
            recipient.sendTl("helpOp", from.getDisplayName(), message);
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        return Collections.emptyList();
    }
}

