/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.MetaItemStack;
import com.earth2me.essentials.Potions;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.StringUtil;
import com.earth2me.essentials.utils.VersionUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import net.ess3.api.TranslatableException;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Commandpotion
extends EssentialsCommand {
    public Commandpotion() {
        super("potion");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        boolean holdingPotion;
        ItemStack stack = user.getItemInHand();
        if (args.length == 0) {
            TreeSet<String> potionslist = new TreeSet<String>();
            for (Map.Entry<String, PotionEffectType> entry : Potions.entrySet()) {
                String potionName = entry.getValue().getName().toLowerCase(Locale.ENGLISH);
                if (!potionslist.contains(potionName) && !user.isAuthorized("essentials.potions." + potionName)) continue;
                potionslist.add(entry.getKey());
            }
            throw new NotEnoughArgumentsException(user.playerTl("potions", StringUtil.joinList(potionslist.toArray())));
        }
        boolean bl = holdingPotion = stack.getType() == Material.POTION;
        if (!holdingPotion && VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_9_R01)) {
            boolean bl2 = holdingPotion = stack.getType() == Material.SPLASH_POTION || stack.getType() == Material.LINGERING_POTION;
        }
        if (!holdingPotion) throw new TranslatableException("holdPotion", new Object[0]);
        PotionMeta pmeta = (PotionMeta)stack.getItemMeta();
        if (args[0].equalsIgnoreCase("clear")) {
            pmeta.clearCustomEffects();
            stack.setItemMeta((ItemMeta)pmeta);
            return;
        } else if (args[0].equalsIgnoreCase("apply") && user.isAuthorized("essentials.potion.apply")) {
            for (PotionEffect effect : pmeta.getCustomEffects()) {
                effect.apply((LivingEntity)user.getBase());
            }
            return;
        } else {
            if (args.length < 3) {
                throw new NotEnoughArgumentsException();
            }
            MetaItemStack mStack = new MetaItemStack(stack);
            for (String arg : args) {
                mStack.addPotionMeta(user.getSource(), true, arg, this.ess);
            }
            if (mStack.completePotion()) {
                pmeta = (PotionMeta)mStack.getItemStack().getItemMeta();
                stack.setItemMeta((ItemMeta)pmeta);
                return;
            } else {
                user.sendTl("invalidPotion", new Object[0]);
                throw new NotEnoughArgumentsException();
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList();
            options.add("clear");
            if (user.isAuthorized("essentials.potion.apply")) {
                options.add("apply");
            }
            for (Map.Entry<String, PotionEffectType> entry : Potions.entrySet()) {
                String potionName = entry.getValue().getName().toLowerCase(Locale.ENGLISH);
                if (!user.isAuthorized("essentials.potions." + potionName)) continue;
                options.add("effect:" + entry.getKey());
            }
            return options;
        }
        if (args.length == 2 && args[0].startsWith("effect:")) {
            return Lists.newArrayList((Object[])new String[]{"power:1", "power:2", "power:3", "power:4", "amplifier:0", "amplifier:1", "amplifier:2", "amplifier:3"});
        }
        if (args.length == 3 && args[0].startsWith("effect:")) {
            ArrayList options = Lists.newArrayList();
            for (String duration : COMMON_DURATIONS) {
                options.add("duration:" + duration);
            }
            return options;
        }
        if (args.length == 4 && args[0].startsWith("effect:")) {
            return Lists.newArrayList((Object[])new String[]{"splash:true", "splash:false"});
        }
        return Collections.emptyList();
    }
}

