/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerExemptException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.StringUtil;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.ess3.api.MaxMoneyException;
import net.ess3.api.TranslatableException;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public abstract class EssentialsLoopCommand
extends EssentialsCommand {
    public EssentialsLoopCommand(String command) {
        super(command);
    }

    protected void loopOfflinePlayers(Server server, CommandSource sender, boolean multipleStringMatches, boolean matchWildcards, String searchTerm, String[] commandArgs) throws TranslatableException, NotEnoughArgumentsException {
        this.loopOfflinePlayersConsumer(server, sender, multipleStringMatches, matchWildcards, searchTerm, user -> this.updatePlayer(server, sender, user, commandArgs));
    }

    protected void loopOfflinePlayersConsumer(Server server, CommandSource sender, boolean multipleStringMatches, boolean matchWildcards, String searchTerm, UserConsumer userConsumer) throws TranslatableException, NotEnoughArgumentsException {
        if (searchTerm.isEmpty()) {
            throw new PlayerNotFoundException();
        }
        UUID uuid = StringUtil.toUUID(searchTerm);
        if (uuid != null) {
            User matchedUser = this.ess.getUser(uuid);
            if (matchedUser == null) {
                throw new PlayerNotFoundException();
            }
            userConsumer.accept(matchedUser);
        } else if (matchWildcards && searchTerm.contentEquals("**")) {
            for (UUID u : this.ess.getUsers().getAllUserUUIDs()) {
                User user = this.ess.getUsers().loadUncachedUser(u);
                if (user == null) continue;
                userConsumer.accept(user);
            }
        } else if (matchWildcards && searchTerm.contentEquals("*")) {
            boolean skipHidden = sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).canInteractVanished();
            for (User onlineUser : this.ess.getOnlineUsers()) {
                if (skipHidden && onlineUser.isHidden(sender.getPlayer()) && onlineUser.isHiddenFrom(sender.getPlayer())) continue;
                userConsumer.accept(onlineUser);
            }
        } else if (multipleStringMatches) {
            if (searchTerm.trim().length() < 3) {
                throw new PlayerNotFoundException();
            }
            List matchedPlayers = server.matchPlayer(searchTerm);
            if (matchedPlayers.isEmpty()) {
                User matchedUser = this.getPlayer(server, searchTerm, true, true);
                userConsumer.accept(matchedUser);
            }
            for (Player matchPlayer : matchedPlayers) {
                User matchedUser = this.ess.getUser(matchPlayer);
                userConsumer.accept(matchedUser);
            }
        } else {
            User user = this.getPlayer(server, searchTerm, true, true);
            userConsumer.accept(user);
        }
    }

    protected void loopOnlinePlayers(Server server, CommandSource sender, boolean multipleStringMatches, boolean matchWildcards, String searchTerm, String[] commandArgs) throws TranslatableException, NotEnoughArgumentsException {
        this.loopOnlinePlayersConsumer(server, sender, multipleStringMatches, matchWildcards, searchTerm, user -> this.updatePlayer(server, sender, user, commandArgs));
    }

    protected void loopOnlinePlayersConsumer(Server server, CommandSource sender, boolean multipleStringMatches, boolean matchWildcards, String searchTerm, UserConsumer userConsumer) throws NotEnoughArgumentsException, TranslatableException {
        boolean skipHidden;
        if (searchTerm.isEmpty()) {
            throw new PlayerNotFoundException();
        }
        boolean bl = skipHidden = sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).canInteractVanished();
        if (matchWildcards && (searchTerm.contentEquals("**") || searchTerm.contentEquals("*"))) {
            for (User onlineUser : this.ess.getOnlineUsers()) {
                if (skipHidden && onlineUser.isHidden(sender.getPlayer()) && onlineUser.isHiddenFrom(sender.getPlayer())) continue;
                userConsumer.accept(onlineUser);
            }
        } else if (multipleStringMatches) {
            if (searchTerm.trim().length() < 2) {
                throw new PlayerNotFoundException();
            }
            boolean foundUser = false;
            List matchedPlayers = server.matchPlayer(searchTerm);
            if (matchedPlayers.isEmpty()) {
                String matchText = searchTerm.toLowerCase(Locale.ENGLISH);
                for (User player : this.ess.getOnlineUsers()) {
                    String displayName;
                    if (skipHidden && player.isHidden(sender.getPlayer()) && player.isHiddenFrom(sender.getPlayer()) || !(displayName = FormatUtil.stripFormat(player.getDisplayName()).toLowerCase(Locale.ENGLISH)).contains(matchText)) continue;
                    foundUser = true;
                    userConsumer.accept(player);
                }
            } else {
                for (Player matchPlayer : matchedPlayers) {
                    User player = this.ess.getUser(matchPlayer);
                    if (skipHidden && player.isHidden(sender.getPlayer()) && player.isHiddenFrom(sender.getPlayer())) continue;
                    foundUser = true;
                    userConsumer.accept(player);
                }
            }
            if (!foundUser) {
                throw new PlayerNotFoundException();
            }
        } else {
            User player = this.getPlayer(server, sender, searchTerm);
            userConsumer.accept(player);
        }
    }

    protected abstract void updatePlayer(Server var1, CommandSource var2, User var3, String[] var4) throws NotEnoughArgumentsException, PlayerExemptException, ChargeException, MaxMoneyException;

    @Override
    protected List<String> getPlayers(Server server, CommandSource interactor) {
        List<String> players = super.getPlayers(server, interactor);
        players.add("**");
        players.add("*");
        return players;
    }

    @Override
    protected List<String> getPlayers(Server server, User interactor) {
        List<String> players = super.getPlayers(server, interactor);
        players.add("**");
        players.add("*");
        return players;
    }

    public static interface UserConsumer {
        public void accept(User var1) throws NotEnoughArgumentsException, TranslatableException;
    }
}

