/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public abstract class EssentialsToggleCommand
extends EssentialsCommand {
    final String othersPermission;

    public EssentialsToggleCommand(String command, String othersPermission) {
        super(command);
        this.othersPermission = othersPermission;
    }

    protected void handleToggleWithArgs(Server server, User user, String[] args) throws Exception {
        if (args.length == 1) {
            Boolean toggle = this.matchToggleArgument(args[0]);
            if (toggle == null && user.isAuthorized(this.othersPermission)) {
                this.toggleOtherPlayers(server, user.getSource(), args);
            } else {
                this.togglePlayer(user.getSource(), user, toggle);
            }
        } else if (args.length == 2 && user.isAuthorized(this.othersPermission)) {
            this.toggleOtherPlayers(server, user.getSource(), args);
        } else {
            this.togglePlayer(user.getSource(), user, null);
        }
    }

    protected Boolean matchToggleArgument(String arg) {
        if (arg.equalsIgnoreCase("on") || arg.startsWith("ena") || arg.equalsIgnoreCase("1")) {
            return true;
        }
        if (arg.equalsIgnoreCase("off") || arg.startsWith("dis") || arg.equalsIgnoreCase("0")) {
            return false;
        }
        return null;
    }

    protected void toggleOtherPlayers(Server server, CommandSource sender, String[] args) throws PlayerNotFoundException, NotEnoughArgumentsException {
        if (args.length < 1 || args[0].trim().length() < 2) {
            throw new PlayerNotFoundException();
        }
        boolean skipHidden = sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).canInteractVanished();
        boolean foundUser = false;
        List matchedPlayers = server.matchPlayer(args[0]);
        for (Player matchPlayer : matchedPlayers) {
            User player = this.ess.getUser(matchPlayer);
            if (skipHidden && player.isHidden(sender.getPlayer()) && player.isHiddenFrom(sender.getPlayer())) continue;
            foundUser = true;
            if (args.length > 1) {
                Boolean toggle = this.matchToggleArgument(args[1]);
                this.togglePlayer(sender, player, toggle);
                continue;
            }
            this.togglePlayer(sender, player, null);
        }
        if (!foundUser) {
            throw new PlayerNotFoundException();
        }
    }

    protected abstract void togglePlayer(CommandSource var1, User var2, Boolean var3) throws NotEnoughArgumentsException;

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            if (user.isAuthorized(this.othersPermission)) {
                return this.getPlayers(server, user);
            }
            return Lists.newArrayList((Object[])new String[]{"enable", "disable"});
        }
        if (args.length == 2 && user.isAuthorized(this.othersPermission)) {
            return Lists.newArrayList((Object[])new String[]{"enable", "disable"});
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"enable", "disable"});
        }
        return Collections.emptyList();
    }
}

