/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.config.processors;

import com.earth2me.essentials.libs.configurate.ConfigurationNode;
import com.earth2me.essentials.libs.configurate.objectmapping.meta.Processor;
import com.earth2me.essentials.libs.configurate.serialize.SerializationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeleteIfIncompleteProcessor
implements Processor<Object> {
    @Override
    public void process(Object value, ConfigurationNode destination) {
        if (value == null) {
            return;
        }
        try {
            if (value instanceof IncompleteEntity && ((IncompleteEntity)value).isIncomplete()) {
                destination.set(null);
            } else if (value instanceof List) {
                boolean modified = false;
                ArrayList newList = new ArrayList((List)value);
                for (Object o : (List)value) {
                    if (!(o instanceof IncompleteEntity) || !((IncompleteEntity)o).isIncomplete()) continue;
                    newList.remove(o);
                    modified = true;
                }
                if (modified) {
                    destination.set(newList);
                }
            } else if (value instanceof Map) {
                boolean modified = false;
                HashMap newMap = new HashMap((Map)value);
                for (Map.Entry entry : newMap.entrySet()) {
                    if (!(entry.getValue() instanceof IncompleteEntity) || !((IncompleteEntity)entry.getValue()).isIncomplete()) continue;
                    newMap.remove(entry.getKey());
                    modified = true;
                }
                if (modified) {
                    destination.set(newMap);
                }
            }
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
    }

    public static interface IncompleteEntity {
        public boolean isIncomplete();
    }
}

