/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.craftbukkit;

import com.earth2me.essentials.craftbukkit.InventoryData;
import com.earth2me.essentials.utils.MaterialUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public final class Inventories {
    private static final int HELM_SLOT = 39;
    private static final int CHEST_SLOT = 38;
    private static final int LEG_SLOT = 37;
    private static final int BOOT_SLOT = 36;
    private static final int BODY_SLOT = 41;
    private static final int SADDLE_SLOT = 42;
    private static final boolean HAS_OFFHAND = VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_9_R01);
    private static final int INVENTORY_SIZE = HAS_OFFHAND ? 41 : 40;

    private Inventories() {
    }

    public static ItemStack getItemInHand(Player player) {
        if (!HAS_OFFHAND) {
            return player.getInventory().getItemInHand();
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack main = inventory.getItemInMainHand();
        return !Inventories.isEmpty(main) ? main : inventory.getItemInOffHand();
    }

    public static ItemStack getItemInMainHand(Player player) {
        if (!HAS_OFFHAND) {
            return player.getInventory().getItemInHand();
        }
        return player.getInventory().getItemInMainHand();
    }

    public static void setItemInMainHand(Player player, ItemStack stack) {
        if (HAS_OFFHAND) {
            player.getInventory().setItemInMainHand(stack);
        } else {
            player.setItemInHand(stack);
        }
    }

    public static void setItemInMainHand(EntityEquipment entityEquipment, ItemStack stack) {
        if (HAS_OFFHAND) {
            entityEquipment.setItemInMainHand(stack);
        } else {
            entityEquipment.setItemInHand(stack);
        }
    }

    public static void setItemInMainHandDropChance(EntityEquipment entityEquipment, float chance) {
        if (HAS_OFFHAND) {
            entityEquipment.setItemInMainHandDropChance(chance);
        } else {
            entityEquipment.setItemInHandDropChance(chance);
        }
    }

    public static boolean containsAtLeast(Player player, ItemStack item, int amount) {
        for (ItemStack invItem : player.getInventory().getContents()) {
            if (Inventories.isEmpty(invItem) || !invItem.isSimilar(item) || (amount -= invItem.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSpace(Player player, int maxStack, boolean includeArmor, ItemStack ... items) {
        items = Inventories.normalizeItems(Inventories.cloneItems(items));
        InventoryData inventoryData = Inventories.parseInventoryData((Inventory)player.getInventory(), items, maxStack, includeArmor);
        List<Integer> emptySlots = inventoryData.getEmptySlots();
        block0: for (ItemStack item : items) {
            if (Inventories.isEmpty(item)) continue;
            int itemMax = Math.max(maxStack, item.getMaxStackSize());
            List<Integer> partialSlots = inventoryData.getPartialSlots().get(item);
            while (true) {
                int existingAmount;
                int amount;
                if (partialSlots == null || partialSlots.isEmpty()) {
                    if (emptySlots.isEmpty()) {
                        return false;
                    }
                    emptySlots.remove(0);
                    if (item.getAmount() <= itemMax) continue block0;
                    item.setAmount(item.getAmount() - itemMax);
                    continue;
                }
                int slot = partialSlots.remove(0);
                ItemStack existing = player.getInventory().getItem(slot);
                if (Inventories.isEmpty(existing)) {
                    existing = item.clone();
                    existing.setAmount(0);
                }
                if ((amount = item.getAmount()) + (existingAmount = existing.getAmount()) <= itemMax) continue block0;
                item.setAmount(amount + existingAmount - itemMax);
            }
        }
        return true;
    }

    public static Map<Integer, ItemStack> addItem(Player player, ItemStack ... items) {
        return Inventories.addItem(player, 0, false, items);
    }

    public static Map<Integer, ItemStack> addItem(Player player, int maxStack, ItemStack ... items) {
        return Inventories.addItem(player, maxStack, false, items);
    }

    public static Map<Integer, ItemStack> addItem(Player player, int maxStack, boolean allowArmor, ItemStack ... items) {
        items = Inventories.normalizeItems(Inventories.cloneItems(items));
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        InventoryData inventoryData = Inventories.parseInventoryData((Inventory)player.getInventory(), items, maxStack, allowArmor);
        List<Integer> emptySlots = inventoryData.getEmptySlots();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (Inventories.isEmpty(item)) continue;
            int itemMax = Math.max(maxStack, item.getMaxStackSize());
            List<Integer> partialSlots = inventoryData.getPartialSlots().get(item);
            while (true) {
                int existingAmount;
                int amount;
                int slot;
                if (partialSlots == null || partialSlots.isEmpty()) {
                    if (emptySlots.isEmpty()) {
                        leftover.put(i, item);
                        continue block0;
                    }
                    slot = emptySlots.remove(0);
                    if (item.getAmount() > itemMax) {
                        ItemStack split = item.clone();
                        split.setAmount(itemMax);
                        player.getInventory().setItem(slot, split);
                        item.setAmount(item.getAmount() - itemMax);
                        continue;
                    }
                    player.getInventory().setItem(slot, item);
                    continue block0;
                }
                slot = partialSlots.remove(0);
                ItemStack existing = player.getInventory().getItem(slot);
                if (Inventories.isEmpty(existing)) {
                    existing = item.clone();
                    existing.setAmount(0);
                }
                if ((amount = item.getAmount()) + (existingAmount = existing.getAmount()) <= itemMax) {
                    existing.setAmount(amount + existingAmount);
                    player.getInventory().setItem(slot, existing);
                    continue block0;
                }
                existing.setAmount(itemMax);
                player.getInventory().setItem(slot, existing);
                item.setAmount(amount + existingAmount - itemMax);
            }
        }
        return leftover;
    }

    public static ItemStack[] getInventory(Player player, boolean includeArmor) {
        ItemStack[] items = new ItemStack[INVENTORY_SIZE];
        for (int i = 0; i < items.length; ++i) {
            items[i] = !includeArmor && Inventories.isArmorSlot(i) ? null : player.getInventory().getItem(i);
        }
        return items;
    }

    public static void removeItemExact(Player player, ItemStack toRemove, boolean includeArmor) {
        Inventories.removeItems(player, itemStack -> itemStack.equals((Object)toRemove), includeArmor);
    }

    public static int removeItemSimilar(Player player, ItemStack toRemove, boolean includeArmor) {
        return Inventories.removeItems(player, itemStack -> itemStack.isSimilar(toRemove), includeArmor);
    }

    public static int removeItems(Player player, Predicate<ItemStack> removePredicate, boolean includeArmor) {
        int removedAmount = 0;
        ItemStack[] items = player.getInventory().getContents();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item;
            if (Inventories.isContortedSlot(i) || !includeArmor && Inventories.isArmorSlot(i) || Inventories.isEmpty(item = items[i]) || !removePredicate.test(item)) continue;
            removedAmount += item.getAmount();
            item.setAmount(0);
            player.getInventory().setItem(i, item);
        }
        return removedAmount;
    }

    public static boolean removeItemAmount(Player player, ItemStack toRemove, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount cannot be negative.");
        }
        ArrayList<Integer> clearSlots = new ArrayList<Integer>();
        ItemStack[] items = player.getInventory().getContents();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item;
            if (Inventories.isContortedSlot(i) || Inventories.isEmpty(item = items[i]) || !item.isSimilar(toRemove)) continue;
            if (item.getAmount() >= amount) {
                item.setAmount(item.getAmount() - amount);
                player.getInventory().setItem(i, item);
                Iterator iterator = clearSlots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    Inventories.clearSlot(player, slot);
                }
                return true;
            }
            clearSlots.add(i);
            if ((amount -= item.getAmount()) != 0) continue;
            Iterator iterator = clearSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                Inventories.clearSlot(player, slot);
            }
            return true;
        }
        return false;
    }

    public static void clearSlot(Player player, int slot) {
        ItemStack item = player.getInventory().getItem(slot);
        if (!Inventories.isEmpty(item)) {
            item.setAmount(0);
            player.getInventory().setItem(slot, item);
        }
    }

    public static void setSlot(Player inventory, int slot, ItemStack item) {
        inventory.getInventory().setItem(slot, item);
    }

    private static ItemStack[] normalizeItems(ItemStack[] items) {
        if (items.length <= 1) {
            return items;
        }
        ItemStack[] normalizedItems = new ItemStack[items.length];
        int nextNormalizedIndex = 0;
        block0: for (ItemStack item : items) {
            if (Inventories.isEmpty(item)) continue;
            for (int j = 0; j < nextNormalizedIndex; ++j) {
                ItemStack normalizedItem = normalizedItems[j];
                if (Inventories.isEmpty(normalizedItem) || !item.isSimilar(normalizedItem)) continue;
                normalizedItem.setAmount(normalizedItem.getAmount() + item.getAmount());
                continue block0;
            }
            normalizedItems[nextNormalizedIndex++] = item;
        }
        return normalizedItems;
    }

    private static ItemStack[] cloneItems(ItemStack[] items) {
        ItemStack[] clonedItems = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (Inventories.isEmpty(item)) continue;
            clonedItems[i] = item.clone();
        }
        return clonedItems;
    }

    private static InventoryData parseInventoryData(Inventory inventory, ItemStack[] items, int maxStack, boolean includeArmor) {
        ItemStack[] inventoryContents = inventory.getContents();
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        HashMap<ItemStack, List<Integer>> partialSlots = new HashMap<ItemStack, List<Integer>>();
        for (int i = 0; i < inventoryContents.length; ++i) {
            if (Inventories.isContortedSlot(i) || !includeArmor && Inventories.isArmorSlot(i)) continue;
            ItemStack invItem = inventoryContents[i];
            if (Inventories.isEmpty(invItem)) {
                emptySlots.add(i);
                continue;
            }
            for (ItemStack newItem : items) {
                if (invItem.getAmount() >= Math.max(maxStack, invItem.getMaxStackSize()) || !invItem.isSimilar(newItem)) continue;
                partialSlots.computeIfAbsent(newItem, k -> new ArrayList()).add(i);
            }
        }
        if (includeArmor) {
            ItemStack helm = null;
            ItemStack chest = null;
            ItemStack legs = null;
            ItemStack boots = null;
            for (ItemStack item : items) {
                if (Inventories.isEmpty(item)) continue;
                if (helm == null && MaterialUtil.isHelmet(item.getType())) {
                    helm = item;
                    if (!emptySlots.contains(39)) continue;
                    partialSlots.computeIfAbsent(helm, k -> new ArrayList()).add(39);
                    continue;
                }
                if (chest == null && MaterialUtil.isChestplate(item.getType())) {
                    chest = item;
                    if (!emptySlots.contains(38)) continue;
                    partialSlots.computeIfAbsent(chest, k -> new ArrayList()).add(38);
                    continue;
                }
                if (legs == null && MaterialUtil.isLeggings(item.getType())) {
                    legs = item;
                    if (!emptySlots.contains(37)) continue;
                    partialSlots.computeIfAbsent(legs, k -> new ArrayList()).add(37);
                    continue;
                }
                if (boots != null || !MaterialUtil.isBoots(item.getType())) continue;
                boots = item;
                if (!emptySlots.contains(36)) continue;
                partialSlots.computeIfAbsent(boots, k -> new ArrayList()).add(36);
            }
            emptySlots.remove((Object)39);
            emptySlots.remove((Object)38);
            emptySlots.remove((Object)37);
            emptySlots.remove((Object)36);
        }
        return new InventoryData(emptySlots, partialSlots);
    }

    private static boolean isEmpty(ItemStack stack) {
        return stack == null || MaterialUtil.isAir(stack.getType());
    }

    public static boolean isContortedSlot(int slot) {
        return slot == 41 || slot == 42;
    }

    private static boolean isArmorSlot(int slot) {
        return slot == 39 || slot == 38 || slot == 37 || slot == 36;
    }
}

