/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.items;

import com.earth2me.essentials.ManagedFile;
import com.earth2me.essentials.items.AbstractItemDb;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.ess3.api.IEssentials;
import net.ess3.api.TranslatableException;
import net.ess3.provider.PersistentDataProvider;
import net.ess3.provider.PotionMetaProvider;
import net.ess3.provider.SpawnerItemProvider;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class FlatItemDb
extends AbstractItemDb {
    private static final Gson gson = new Gson();
    private final transient Map<String, ItemData> items = new HashMap<String, ItemData>();
    private final transient Map<String, String> itemAliases = new HashMap<String, String>();
    private final transient Set<String> allAliases = new HashSet<String>();
    private transient ManagedFile file = null;

    public FlatItemDb(IEssentials ess) {
        super(ess);
    }

    @Override
    public void reloadConfig() {
        if (this.file == null) {
            this.file = new ManagedFile("items.json", this.ess);
        }
        this.rebuild();
        this.ess.getLogger().info(String.format("Loaded %s items from items.json.", this.listNames().size()));
    }

    private void rebuild() {
        this.reset();
        String json = this.file.getLines().stream().filter(line -> !line.startsWith("#")).collect(Collectors.joining());
        this.loadJSON(String.join((CharSequence)"\n", json));
        this.ready = true;
    }

    private void reset() {
        this.ready = false;
        this.items.clear();
        this.itemAliases.clear();
        this.allAliases.clear();
    }

    private void loadJSON(String source) {
        JsonObject map = new JsonParser().parse(source).getAsJsonObject();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            boolean valid = false;
            if (element.isJsonObject()) {
                ItemData data = (ItemData)gson.fromJson(element, ItemData.class);
                this.items.put(key, data);
                valid = true;
            } else {
                try {
                    String target = element.getAsString();
                    this.itemAliases.put(key, target);
                    valid = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (valid) {
                this.allAliases.add(key);
                continue;
            }
            this.ess.getLogger().warning(String.format("Failed to add item: \"%s\": %s", key, element.toString()));
        }
    }

    @Override
    public ItemStack get(String id, boolean useResolvers) throws Exception {
        ItemStack resolved;
        if (useResolvers && (resolved = this.tryResolverDeserialize(id)) != null) {
            return resolved;
        }
        String[] split = (id = id.toLowerCase()).split("(?<!^minecraft):");
        ItemData data = this.getByName(split[0]);
        if (data == null) {
            throw new TranslatableException("unknownItemName", id);
        }
        Material material = data.getMaterial();
        if (!material.isItem()) {
            throw new TranslatableException("unableToSpawnItem", id);
        }
        ItemStack stack = new ItemStack(material);
        stack.setAmount(material.getMaxStackSize());
        ItemData.EssentialPotionData potionData = data.getPotionData();
        if (potionData != null && stack.getItemMeta() instanceof PotionMeta) {
            this.ess.provider(PotionMetaProvider.class).setBasePotionType(stack, potionData.getType(), potionData.isExtended(), potionData.isUpgraded());
        }
        ItemMeta meta = stack.getItemMeta();
        if (split.length > 1 && meta instanceof Damageable) {
            Damageable damageMeta = (Damageable)meta;
            damageMeta.setDamage(Integer.parseInt(split[1]));
        }
        stack.setItemMeta(meta);
        EntityType entity = data.getEntity();
        if (entity != null && material.toString().contains("SPAWNER")) {
            this.ess.provider(SpawnerItemProvider.class).setEntityType(stack, entity);
            this.ess.provider(PersistentDataProvider.class).set(stack, "convert", "true");
        }
        return stack;
    }

    private ItemData getByName(String name) {
        if (this.items.containsKey(name = name.toLowerCase())) {
            return this.items.get(name);
        }
        if (this.itemAliases.containsKey(name)) {
            return this.items.get(this.itemAliases.get(name));
        }
        return null;
    }

    @Override
    public List<String> nameList(ItemStack item) {
        ArrayList<String> names = new ArrayList<String>();
        String primaryName = this.name(item);
        names.add(primaryName);
        for (Map.Entry<String, String> entry : this.itemAliases.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(primaryName)) continue;
            names.add(entry.getKey());
        }
        return names;
    }

    @Override
    public String name(ItemStack item) {
        ItemData data = this.lookup(item);
        for (Map.Entry<String, ItemData> entry : this.items.entrySet()) {
            if (!entry.getValue().equals(data)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    @Deprecated
    public int getLegacyId(Material material) {
        throw new UnsupportedOperationException("Legacy IDs aren't supported on this version.");
    }

    private ItemData lookup(ItemStack is) {
        Material type = is.getType();
        if (MaterialUtil.isPotion(type) && is.getItemMeta() instanceof PotionMeta) {
            PotionMetaProvider provider = this.ess.provider(PotionMetaProvider.class);
            return new ItemData(type, new ItemData.EssentialPotionData(provider.getBasePotionType(is), provider.isUpgraded(is), provider.isExtended(is)));
        }
        if (type.toString().contains("SPAWNER")) {
            EntityType entity = this.ess.provider(SpawnerItemProvider.class).getEntityType(is);
            return new ItemData(type, entity);
        }
        return new ItemData(type);
    }

    @Override
    public Collection<String> listNames() {
        HashSet<String> names = new HashSet<String>(this.allAliases);
        names.addAll(this.getResolverNames());
        return names;
    }

    public static class ItemData {
        private Material material;
        private String[] fallbacks = null;
        private EssentialPotionData potionData = null;
        private EntityType entity = null;

        ItemData(Material material) {
            this.material = material;
        }

        ItemData(Material material, EssentialPotionData potionData) {
            this.material = material;
            this.potionData = potionData;
        }

        ItemData(Material material, EntityType entity) {
            this.material = material;
            this.entity = entity;
        }

        public int hashCode() {
            return 31 * this.material.hashCode() ^ this.potionData.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ItemData)) {
                return false;
            }
            ItemData that = (ItemData)o;
            return this.getMaterial() == that.getMaterial() && this.potionDataEquals(that) && this.entityEquals(that);
        }

        public Material getMaterial() {
            if (this.material == null && this.fallbacks != null) {
                this.material = EnumUtil.getMaterial(this.fallbacks);
                this.fallbacks = null;
            }
            return this.material;
        }

        public EssentialPotionData getPotionData() {
            return this.potionData;
        }

        public EntityType getEntity() {
            return this.entity;
        }

        private boolean potionDataEquals(ItemData o) {
            if (this.potionData == null && o.getPotionData() == null) {
                return true;
            }
            if (this.potionData != null && o.getPotionData() != null) {
                return this.potionData.equals(o.getPotionData());
            }
            return false;
        }

        private boolean entityEquals(ItemData o) {
            if (this.entity == null && o.getEntity() == null) {
                return true;
            }
            if (this.entity != null && o.getEntity() != null) {
                return this.entity.equals((Object)o.getEntity());
            }
            return false;
        }

        public static class EssentialPotionData {
            private PotionType type;
            private String fallbackType;
            private final boolean upgraded;
            private final boolean extended;

            EssentialPotionData(PotionType type, boolean upgraded, boolean extended) {
                this.type = type;
                this.upgraded = upgraded;
                this.extended = extended;
            }

            public PotionType getType() {
                if (this.type == null && this.fallbackType != null) {
                    this.type = EnumUtil.valueOf(PotionType.class, this.fallbackType);
                    this.fallbackType = null;
                }
                return this.type;
            }

            public boolean isUpgraded() {
                return this.upgraded;
            }

            public boolean isExtended() {
                return this.extended;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                EssentialPotionData that = (EssentialPotionData)o;
                return this.upgraded == that.upgraded && this.extended == that.extended && this.getType() == that.getType();
            }

            public int hashCode() {
                return Objects.hash(this.getType(), this.upgraded, this.extended);
            }
        }
    }
}

