/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.libs.configurate.objectmapping;

import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.Nullable;
import com.earth2me.essentials.libs.configurate.ConfigurationNode;
import com.earth2me.essentials.libs.configurate.objectmapping.AutoValue_FieldData;
import com.earth2me.essentials.libs.configurate.objectmapping.meta.Constraint;
import com.earth2me.essentials.libs.configurate.objectmapping.meta.NodeResolver;
import com.earth2me.essentials.libs.configurate.objectmapping.meta.Processor;
import com.earth2me.essentials.libs.configurate.serialize.SerializationException;
import com.earth2me.essentials.libs.configurate.serialize.TypeSerializer;
import com.earth2me.essentials.libs.configurate.util.CheckedFunction;
import com.earth2me.essentials.libs.configurate.util.UnmodifiableCollections;
import com.earth2me.essentials.libs.geantyref.GenericTypeReflector;
import com.google.auto.value.AutoValue;
import java.lang.reflect.AnnotatedType;
import java.util.List;
import java.util.function.Supplier;

@AutoValue
public abstract class FieldData<I, O> {
    static <I, O> FieldData<I, O> of(String name, AnnotatedType resolvedFieldType, List<Constraint<?>> constraints, List<Processor<?>> processors, Deserializer<I> deserializer, CheckedFunction<O, @Nullable Object, Exception> serializer, NodeResolver resolver) {
        return new AutoValue_FieldData<I, O>(name, resolvedFieldType, UnmodifiableCollections.copyOf(constraints), UnmodifiableCollections.copyOf(processors), deserializer, serializer, resolver);
    }

    FieldData() {
    }

    public abstract String name();

    public abstract AnnotatedType resolvedType();

    abstract List<Constraint<?>> constraints();

    abstract List<Processor<?>> processors();

    abstract Deserializer<I> deserializer();

    abstract CheckedFunction<O, @Nullable Object, Exception> serializer();

    abstract NodeResolver nodeResolver();

    public boolean isValid(Object instance) {
        try {
            this.validate(instance);
            return true;
        }
        catch (SerializationException ex) {
            return false;
        }
    }

    public void validate(@Nullable Object instance) throws SerializationException {
        if (instance != null && !GenericTypeReflector.erase(GenericTypeReflector.box(this.resolvedType().getType())).isInstance(instance)) {
            throw new SerializationException("Object " + instance + " is not of expected type " + this.resolvedType().getType());
        }
        for (Constraint<?> constraint : this.constraints()) {
            constraint.validate(instance);
        }
    }

    TypeSerializer<?> serializerFrom(ConfigurationNode node) throws SerializationException {
        @Nullable TypeSerializer<?> serial = node.options().serializers().get(this.resolvedType());
        if (serial == null) {
            throw new SerializationException("No TypeSerializer found for field " + this.name() + " of type " + this.resolvedType().getType());
        }
        return serial;
    }

    public @Nullable ConfigurationNode resolveNode(ConfigurationNode source) {
        return this.nodeResolver().resolve(source);
    }

    @FunctionalInterface
    public static interface Deserializer<I> {
        public void accept(I var1, @Nullable Object var2, Supplier<@Nullable Object> var3);
    }
}

