/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.libs.configurate.reference;

import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.Nullable;
import com.earth2me.essentials.libs.configurate.ConfigurateException;
import com.earth2me.essentials.libs.configurate.ConfigurationNode;
import com.earth2me.essentials.libs.configurate.NodePath;
import com.earth2me.essentials.libs.configurate.ScopedConfigurationNode;
import com.earth2me.essentials.libs.configurate.loader.ConfigurationLoader;
import com.earth2me.essentials.libs.configurate.reactive.Publisher;
import com.earth2me.essentials.libs.configurate.reference.ManualConfigurationReference;
import com.earth2me.essentials.libs.configurate.reference.ValueReference;
import com.earth2me.essentials.libs.configurate.reference.WatchServiceListener;
import com.earth2me.essentials.libs.configurate.reference.WatchingConfigurationReference;
import com.earth2me.essentials.libs.configurate.serialize.SerializationException;
import com.earth2me.essentials.libs.geantyref.TypeToken;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;

public interface ConfigurationReference<N extends ConfigurationNode>
extends AutoCloseable {
    public static <N extends ScopedConfigurationNode<N>> ConfigurationReference<N> fixed(ConfigurationLoader<? extends N> loader) throws ConfigurateException {
        ManualConfigurationReference<N> ret = new ManualConfigurationReference<N>(loader, ForkJoinPool.commonPool());
        ret.load();
        return ret;
    }

    public static <T extends ScopedConfigurationNode<T>> ConfigurationReference<T> watching(Function<Path, ConfigurationLoader<? extends T>> loaderCreator, Path file, WatchServiceListener listener) throws ConfigurateException {
        WatchingConfigurationReference<T> ret = new WatchingConfigurationReference<T>(loaderCreator.apply(file), listener.taskExecutor);
        ret.load();
        ret.disposable(listener.listenToFile(file, ret));
        return ret;
    }

    public void load() throws ConfigurateException;

    public void save() throws ConfigurateException;

    public void save(ConfigurationNode var1) throws ConfigurateException;

    public Publisher<N> saveAsync();

    public Publisher<N> updateAsync(Function<N, ? extends N> var1);

    public N node();

    public ConfigurationLoader<? extends N> loader();

    public N get(Object ... var1);

    public N get(Iterable<?> var1);

    default public void set(Object[] path, @Nullable Object value) throws SerializationException {
        this.node().node(path).set(value);
    }

    default public <T> void set(Object[] path, Class<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path).set(type, value);
    }

    default public <T> void set(Object[] path, TypeToken<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path).set(type, value);
    }

    default public void set(NodePath path, @Nullable Object value) throws SerializationException {
        this.node().node(path).set(value);
    }

    default public <T> void set(NodePath path, Class<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path).set(type, value);
    }

    default public <T> void set(NodePath path, TypeToken<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path).set(type, value);
    }

    default public <T> ValueReference<T, N> referenceTo(TypeToken<T> type, Object ... path) throws SerializationException {
        return this.referenceTo(type, NodePath.of(path));
    }

    default public <T> ValueReference<T, N> referenceTo(Class<T> type, Object ... path) throws SerializationException {
        return this.referenceTo(type, NodePath.of(path));
    }

    default public <T> ValueReference<T, N> referenceTo(TypeToken<T> type, NodePath path) throws SerializationException {
        return this.referenceTo(type, path, null);
    }

    default public <T> ValueReference<T, N> referenceTo(Class<T> type, NodePath path) throws SerializationException {
        return this.referenceTo(type, path, null);
    }

    public <T> ValueReference<T, N> referenceTo(TypeToken<T> var1, NodePath var2, @Nullable T var3) throws SerializationException;

    public <T> ValueReference<T, N> referenceTo(Class<T> var1, NodePath var2, @Nullable T var3) throws SerializationException;

    public Publisher<N> updates();

    public Publisher<Map.Entry<ErrorPhase, Throwable>> errors();

    @Override
    public void close();

    public static enum ErrorPhase {
        LOADING,
        SAVING,
        UNKNOWN,
        VALUE;

    }
}

