/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.userstorage;

import com.earth2me.essentials.OfflinePlayerStub;
import com.earth2me.essentials.User;
import com.earth2me.essentials.userstorage.IUserMap;
import com.earth2me.essentials.userstorage.ModernUUIDCache;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import org.bukkit.entity.Player;

public class ModernUserMap
extends CacheLoader<UUID, User>
implements IUserMap {
    private final transient IEssentials ess;
    private final transient ModernUUIDCache uuidCache;
    private final transient LoadingCache<UUID, User> userCache;
    private final boolean debugPrintStackWithWarn;
    private final long debugMaxWarnsPerType;
    private final boolean debugLogCache;
    private final ConcurrentMap<String, AtomicLong> debugNonPlayerWarnCounts;

    public ModernUserMap(IEssentials ess) {
        this.ess = ess;
        this.uuidCache = new ModernUUIDCache(ess);
        this.userCache = CacheBuilder.newBuilder().maximumSize((long)ess.getSettings().getMaxUserCacheCount()).expireAfterAccess(ess.getSettings().getMaxUserCacheValueExpiry(), TimeUnit.SECONDS).softValues().build((CacheLoader)this);
        String printStackProperty = System.getProperty("net.essentialsx.usermap.print-stack", "false");
        String maxWarnProperty = System.getProperty("net.essentialsx.usermap.max-warns", "10");
        String logCacheProperty = System.getProperty("net.essentialsx.usermap.log-cache", "false");
        this.debugMaxWarnsPerType = NumberUtil.isLong(maxWarnProperty) ? Long.parseLong(maxWarnProperty) : -1L;
        this.debugPrintStackWithWarn = Boolean.parseBoolean(printStackProperty);
        this.debugLogCache = Boolean.parseBoolean(logCacheProperty);
        this.debugNonPlayerWarnCounts = new ConcurrentHashMap<String, AtomicLong>();
    }

    @Override
    public Set<UUID> getAllUserUUIDs() {
        return this.uuidCache.getCachedUUIDs();
    }

    @Override
    public long getCachedCount() {
        return this.userCache.size();
    }

    @Override
    public int getUserCount() {
        return this.uuidCache.getCacheSize();
    }

    @Override
    public User getUser(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            return (User)this.userCache.get((Object)uuid);
        }
        catch (ExecutionException e) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.WARNING, "Exception while getting user for " + uuid, e);
            }
            return null;
        }
    }

    @Override
    public User getUser(Player base) {
        User user = this.loadUncachedUser(base);
        this.userCache.put((Object)user.getUUID(), (Object)user);
        this.debugLogCache(user);
        return user;
    }

    @Override
    public User getUser(String name) {
        if (name == null) {
            return null;
        }
        User user = this.getUser(this.uuidCache.getCachedUUID(name));
        if (user != null && user.getBase() instanceof OfflinePlayerStub) {
            if (user.getLastAccountName() != null) {
                ((OfflinePlayerStub)user.getBase()).setName(user.getLastAccountName());
            } else {
                ((OfflinePlayerStub)user.getBase()).setName(name);
            }
        }
        return user;
    }

    public void addCachedNpcName(UUID uuid, String name) {
        if (uuid == null || name == null) {
            return;
        }
        this.uuidCache.updateCache(uuid, name);
    }

    public User load(UUID uuid) throws Exception {
        User user = this.loadUncachedUser(uuid);
        if (user != null) {
            this.debugLogCache(user);
            return user;
        }
        throw new Exception("User not found!");
    }

    @Override
    public User loadUncachedUser(Player base) {
        if (base == null) {
            return null;
        }
        User user = this.getUser(base.getUniqueId());
        if (user == null) {
            this.debugLogUncachedNonPlayer(base);
            user = new User(base, this.ess);
        } else if (!base.equals((Object)user.getBase())) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.INFO, "Essentials updated the underlying Player object for " + user.getUUID());
            }
            user.update(base);
        }
        this.uuidCache.updateCache(user.getUUID(), user.getName());
        return user;
    }

    @Override
    public User loadUncachedUser(UUID uuid) {
        User user = (User)this.userCache.getIfPresent((Object)uuid);
        if (user != null) {
            return user;
        }
        Player player = this.ess.getServer().getPlayer(uuid);
        if (player != null) {
            user = new User(player, this.ess);
            this.uuidCache.updateCache(uuid, player.getName());
            return user;
        }
        File userFile = this.getUserFile(uuid);
        if (userFile.exists()) {
            player = new OfflinePlayerStub(uuid, this.ess.getServer());
            user = new User(player, this.ess);
            String accName = user.getLastAccountName();
            ((OfflinePlayerStub)player).setName(accName);
            this.uuidCache.updateCache(uuid, accName == null || this.uuidCache.getNameCache().containsKey(accName) ? null : accName);
            return user;
        }
        return null;
    }

    @Override
    public Map<String, UUID> getNameCache() {
        return this.uuidCache.getNameCache();
    }

    public String getSanitizedName(String name) {
        return this.uuidCache.getSanitizedName(name);
    }

    public void blockingSave() {
        this.uuidCache.blockingSave();
    }

    public void invalidate(UUID uuid) {
        this.userCache.invalidate((Object)uuid);
        this.uuidCache.removeCache(uuid);
    }

    private File getUserFile(UUID uuid) {
        return new File(new File(this.ess.getDataFolder(), "userdata"), uuid.toString() + ".yml");
    }

    public void shutdown() {
        this.uuidCache.shutdown();
    }

    private void debugLogCache(User user) {
        if (!this.debugLogCache) {
            return;
        }
        Throwable throwable = new Throwable();
        this.ess.getLogger().log(Level.INFO, String.format("Caching user %s (%s)", user.getName(), user.getUUID()), throwable);
    }

    private void debugLogUncachedNonPlayer(Player base) {
        String typeName = base.getClass().getName();
        long count = this.debugNonPlayerWarnCounts.computeIfAbsent(typeName, name -> new AtomicLong(0L)).getAndIncrement();
        if (this.debugMaxWarnsPerType < 0L || count <= this.debugMaxWarnsPerType) {
            Throwable throwable = this.debugPrintStackWithWarn ? new Throwable() : null;
            this.ess.getLogger().log(Level.INFO, "Created a User for " + base.getName() + " (" + base.getUniqueId() + ") for non Bukkit type: " + typeName, throwable);
            if (count == this.debugMaxWarnsPerType) {
                this.ess.getLogger().log(Level.WARNING, "Essentials will not log any more warnings for " + typeName + ". Please report this to the EssentialsX team.");
            }
        }
    }
}

