/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.earth2me.essentials.libs.kyori.adventure.text.Component;
import com.earth2me.essentials.libs.kyori.adventure.text.TextComponent;
import com.earth2me.essentials.libs.kyori.adventure.text.flattener.ComponentFlattener;
import com.earth2me.essentials.libs.kyori.adventure.text.format.NamedTextColor;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.MiniMessage;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.tag.Tag;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.earth2me.essentials.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.earth2me.essentials.utils.VersionUtil;
import net.ess3.api.IEssentials;
import net.ess3.provider.AbstractChatEvent;

public final class AdventureUtil {
    private static final LegacyComponentSerializer LEGACY_SERIALIZER;
    private static final MiniMessage MINI_MESSAGE_NO_TAGS;
    private static final String LOOKUP = "0123456789abcdefklmnor";
    private static final NamedTextColor[] COLORS;
    private static IEssentials ess;
    private static MiniMessage miniMessageInstance;

    private AdventureUtil() {
    }

    public static void setEss(IEssentials ess) {
        AdventureUtil.ess = ess;
        miniMessageInstance = AdventureUtil.createMiniMessageInstance();
    }

    private static MiniMessage createMiniMessageInstance() {
        return MiniMessage.builder().tags(TagResolver.builder().resolvers(TagResolver.standard()).resolver(TagResolver.resolver("primary", AdventureUtil.supplyTag(true))).resolver(TagResolver.resolver("secondary", AdventureUtil.supplyTag(false))).build()).build();
    }

    public static MiniMessage miniMessage() {
        return miniMessageInstance;
    }

    public static Component legacyToAdventure(String text) {
        return LEGACY_SERIALIZER.deserialize(text);
    }

    public static String adventureToLegacy(Component component) {
        return LEGACY_SERIALIZER.serialize(component);
    }

    public static String miniToLegacy(String format) {
        return AdventureUtil.adventureToLegacy(AdventureUtil.miniMessage().deserialize(format));
    }

    public static String legacyToMini(String text) {
        return AdventureUtil.legacyToMini(text, false);
    }

    public static String legacyToMini(String text, boolean useCustomTags) {
        TextComponent deserializedText = LEGACY_SERIALIZER.deserialize(text);
        if (useCustomTags) {
            return (String)miniMessageInstance.serialize(deserializedText);
        }
        return (String)MINI_MESSAGE_NO_TAGS.serialize(deserializedText);
    }

    public static NamedTextColor fromChar(char c) {
        int index = LOOKUP.indexOf(c);
        if (index == -1 || index > 15) {
            return null;
        }
        return COLORS[index];
    }

    public static String escapeTags(String input) {
        return AdventureUtil.miniMessage().escapeTags(input);
    }

    public static ParsedPlaceholder parsed(String literal) {
        return new ParsedPlaceholder(literal);
    }

    private static Tag supplyTag(boolean primary) {
        if (primary) {
            return ess != null ? ess.getSettings().getPrimaryColor() : Tag.styling(NamedTextColor.GOLD);
        }
        return ess != null ? ess.getSettings().getSecondaryColor() : Tag.styling(NamedTextColor.RED);
    }

    static {
        COLORS = new NamedTextColor[]{NamedTextColor.BLACK, NamedTextColor.DARK_BLUE, NamedTextColor.DARK_GREEN, NamedTextColor.DARK_AQUA, NamedTextColor.DARK_RED, NamedTextColor.DARK_PURPLE, NamedTextColor.GOLD, NamedTextColor.GRAY, NamedTextColor.DARK_GRAY, NamedTextColor.BLUE, NamedTextColor.GREEN, NamedTextColor.AQUA, NamedTextColor.RED, NamedTextColor.LIGHT_PURPLE, NamedTextColor.YELLOW, NamedTextColor.WHITE};
        LegacyComponentSerializer.Builder builder = LegacyComponentSerializer.builder().flattener(ComponentFlattener.basic()).extractUrls(AbstractChatEvent.URL_PATTERN).hexColors().useUnusualXRepeatedCharacterHexFormat();
        if (VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_16_1_R01)) {
            builder.hexColors();
        }
        LEGACY_SERIALIZER = builder.build();
        MINI_MESSAGE_NO_TAGS = MiniMessage.builder().strict(true).build();
        miniMessageInstance = AdventureUtil.createMiniMessageInstance();
    }

    public static class ParsedPlaceholder {
        private final String value;

        protected ParsedPlaceholder(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

