/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.provider.providers;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.ess3.provider.AbstractChatEvent;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;

public class PaperChatEvent
implements AbstractChatEvent {
    private final AsyncChatEvent event;
    private final LegacyComponentSerializer serializer;
    private String fakeFormat;

    public PaperChatEvent(AsyncChatEvent event, LegacyComponentSerializer serializer) {
        this.event = event;
        this.serializer = serializer;
    }

    @Override
    public boolean isAsynchronous() {
        return this.event.isAsynchronous();
    }

    @Override
    public boolean isCancelled() {
        return this.event.isCancelled();
    }

    @Override
    public void setCancelled(boolean toCancel) {
        this.event.setCancelled(toCancel);
    }

    @Override
    public String getFormat() {
        return this.fakeFormat;
    }

    @Override
    public void setFormat(String format) {
        this.fakeFormat = format;
    }

    @Override
    public String getMessage() {
        return this.serializer.serialize(this.event.message());
    }

    @Override
    public void setMessage(String message) {
        this.event.message((Component)this.serializer.deserialize(message));
    }

    @Override
    public Player getPlayer() {
        return this.event.getPlayer();
    }

    @Override
    public Set<Player> recipients() {
        HashSet<Player> recipients = new HashSet<Player>();
        for (Audience recipient : this.event.viewers()) {
            if (!(recipient instanceof Player)) continue;
            recipients.add((Player)recipient);
        }
        return Collections.unmodifiableSet(recipients);
    }

    @Override
    public void removeRecipients(Predicate<Player> predicate) {
        this.event.viewers().removeIf(recipient -> recipient instanceof Player && predicate.test((Player)recipient));
    }

    @Override
    public void addRecipient(Player player) {
        this.event.viewers().add(player);
    }
}

