/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command.flag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

public class CommandFlag {
    private final String key;
    private final List<String> aliases;

    @NotNull
    public static Builder<?> builder(@NotNull String key) {
        return new Builder(key);
    }

    protected CommandFlag(@NotNull String key, @NotNull List<String> aliases) {
        this.key = key;
        this.aliases = aliases;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    public String toString() {
        return "Builder{key='" + this.key + "', aliases=" + String.valueOf(this.aliases) + "}";
    }

    public static class Builder<S extends Builder<?>> {
        protected final String key;
        protected final List<String> aliases;

        public Builder(@NotNull String key) {
            this.key = key;
            this.aliases = new ArrayList<String>();
        }

        @NotNull
        public S addAlias(String ... alias) {
            Collections.addAll(this.aliases, alias);
            return (S)this;
        }

        @NotNull
        public CommandFlag build() {
            return new CommandFlag(this.key, this.aliases);
        }
    }
}

