/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command.flag;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.external.acf.commands.InvalidCommandArgument;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public class CommandValueFlag<T>
extends CommandFlag {
    private final Class<T> type;
    private final boolean optional;
    private final T defaultValue;
    private final Function<String, T> context;
    private final Function<String, Collection<String>> completion;

    @NotNull
    public static <T> Builder<T, ?> builder(@NotNull String key, @NotNull Class<T> type) {
        return new Builder(key, type);
    }

    @NotNull
    public static <T extends Enum<T>> EnumBuilder<T, ?> enumBuilder(@NotNull String key, @NotNull Class<T> type) {
        return new EnumBuilder(key, type);
    }

    protected CommandValueFlag(@NotNull String key, @NotNull List<String> aliases, @NotNull Class<T> type, boolean optional, @Nullable T defaultValue, @Nullable Function<String, T> context, @Nullable Function<String, Collection<String>> completion) {
        super(key, aliases);
        this.type = type;
        this.optional = optional;
        this.defaultValue = defaultValue;
        this.context = context;
        this.completion = completion;
    }

    @NotNull
    public Class<T> getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Nullable
    public Function<String, T> getContext() {
        return this.context;
    }

    @Nullable
    public Function<String, Collection<String>> getCompletion() {
        return this.completion;
    }

    public static class Builder<T, S extends Builder<T, S>>
    extends CommandFlag.Builder<S> {
        protected final Class<T> type;
        protected boolean optional = false;
        protected T defaultValue = null;
        protected Function<String, T> context = null;
        protected Function<String, Collection<String>> completion = null;

        public Builder(@NotNull String key, @NotNull Class<T> type) {
            super(key);
            this.type = type;
        }

        @NotNull
        public S optional() {
            this.optional = true;
            return (S)this;
        }

        @NotNull
        public S defaultValue(@NotNull T defaultValue) {
            this.defaultValue = defaultValue;
            return (S)this;
        }

        @NotNull
        public S context(@NotNull Function<String, T> context) {
            this.context = context;
            return (S)this;
        }

        @NotNull
        public S completion(@NotNull Function<String, Collection<String>> completion) {
            this.completion = completion;
            return (S)this;
        }

        @Override
        @NotNull
        public CommandValueFlag<T> build() {
            if (this.context == null && !String.class.equals(this.type)) {
                throw new IllegalStateException("Context is required for non-string value flags");
            }
            return new CommandValueFlag<T>(this.key, this.aliases, this.type, this.optional, this.defaultValue, this.context, this.completion);
        }
    }

    public static class EnumBuilder<T extends Enum<T>, S extends EnumBuilder<T, S>>
    extends CommandFlag.Builder<S> {
        protected final Class<T> type;
        protected boolean optional = false;
        protected T defaultValue = null;
        protected Function<String, T> context = null;
        protected Function<String, Collection<String>> completion = null;

        public EnumBuilder(@NotNull String key, @NotNull Class<T> type) {
            super(key);
            this.type = type;
            this.setEnumContext();
            this.setEnumCompletion();
        }

        private void setEnumContext() {
            this.context = value -> {
                try {
                    return Enum.valueOf(this.type, value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidCommandArgument("Invalid value for argument " + this.key + ": " + value);
                }
            };
        }

        private void setEnumCompletion() {
            List<String> types = Arrays.stream((Enum[])this.type.getEnumConstants()).map(typeClass -> typeClass.name().toLowerCase()).toList();
            this.completion = input -> types;
        }

        @NotNull
        public S optional() {
            this.optional = true;
            return (S)this;
        }

        @NotNull
        public S defaultValue(@NotNull T defaultValue) {
            this.defaultValue = defaultValue;
            return (S)this;
        }

        @Override
        @NotNull
        public CommandValueFlag<T> build() {
            return new CommandValueFlag<T>(this.key, this.aliases, this.type, this.optional, this.defaultValue, this.context, this.completion);
        }
    }
}

