/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.destination.core;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.core.ExactDestination;
import org.mvplugins.multiverse.core.world.location.UnloadedWorldLocation;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;

public final class ExactDestinationInstance
extends DestinationInstance<ExactDestinationInstance, ExactDestination> {
    private final UnloadedWorldLocation location;

    ExactDestinationInstance(@NotNull ExactDestination destination, @NotNull UnloadedWorldLocation location) {
        super(destination);
        this.location = location;
    }

    @Override
    @NotNull
    public Option<Location> getLocation(@NotNull Entity teleportee) {
        if (this.location.getWorld() == null) {
            return Option.none();
        }
        return Option.of(this.location.toBukkitLocation());
    }

    @Override
    @NotNull
    public Option<Vector> getVelocity(@NotNull Entity teleportee) {
        return Option.none();
    }

    @Override
    public boolean checkTeleportSafety() {
        return false;
    }

    @Override
    @NotNull
    public Option<String> getFinerPermissionSuffix() {
        return Option.of(this.location.getWorld()).map(WorldInfo::getName);
    }

    @Override
    @NotNull
    public String serialise() {
        return this.location.getWorldName() + ":" + this.location.getX() + "," + this.location.getY() + "," + this.location.getZ() + ":" + this.location.getPitch() + ":" + this.location.getYaw();
    }
}

