/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.inject;

import java.lang.annotation.Annotation;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.mvplugins.multiverse.core.inject.PluginServiceLocator;
import org.mvplugins.multiverse.core.inject.binder.PluginBinder;
import org.mvplugins.multiverse.external.glassfish.hk2.api.DynamicConfigurationService;
import org.mvplugins.multiverse.external.glassfish.hk2.api.ServiceLocator;
import org.mvplugins.multiverse.external.glassfish.hk2.api.ServiceLocatorFactory;
import org.mvplugins.multiverse.external.glassfish.hk2.internal.ServiceLocatorFactoryImpl;
import org.mvplugins.multiverse.external.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.mvplugins.multiverse.external.glassfish.hk2.utilities.binding.AbstractBinder;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Try;

public final class PluginServiceLocatorFactory {
    private static PluginServiceLocatorFactory instance = null;
    private final ServiceLocatorFactory serviceLocatorFactory = new ServiceLocatorFactoryImpl();
    private ServiceLocator baseServiceLocator;

    public static PluginServiceLocatorFactory get() {
        if (instance == null) {
            instance = new PluginServiceLocatorFactory();
            instance.init().getOrElseThrow(exception -> new IllegalStateException((Throwable)exception));
        }
        return instance;
    }

    private PluginServiceLocatorFactory() {
    }

    @NotNull
    private Try<Void> init() {
        return this.createSystemServiceLocator().flatMap(this::createServerServiceLocator).mapTry(locator -> {
            this.baseServiceLocator = locator;
            return null;
        });
    }

    public void shutdown() {
        this.baseServiceLocator.shutdown();
        this.baseServiceLocator = null;
        instance = null;
    }

    @NotNull
    private Try<ServiceLocator> createSystemServiceLocator() {
        return Try.of(() -> this.serviceLocatorFactory.create("system")).mapTry(systemServiceLocator -> {
            systemServiceLocator.getService(DynamicConfigurationService.class, new Annotation[0]).getPopulator().populate();
            return systemServiceLocator;
        });
    }

    @NotNull
    private Try<ServiceLocator> createServerServiceLocator(@NotNull ServiceLocator systemServiceLocator) {
        return Try.of(() -> this.serviceLocatorFactory.create("server", systemServiceLocator)).mapTry(locator -> {
            ServiceLocatorUtilities.bind(locator, new ServerBinder());
            return locator;
        });
    }

    public <T extends Plugin> Try<PluginServiceLocator> registerPlugin(@NotNull PluginBinder<T> pluginBinder) {
        Objects.requireNonNull(this.baseServiceLocator, "PluginServiceLocatorFactory has not been initialized.");
        return this.createPluginServiceLocator(pluginBinder, this.baseServiceLocator);
    }

    public <T extends Plugin> Try<PluginServiceLocator> registerPlugin(@NotNull PluginBinder<T> pluginBinder, @Nullable PluginServiceLocator parentServiceLocator) {
        if (parentServiceLocator == null) {
            return this.registerPlugin(pluginBinder);
        }
        return this.createPluginServiceLocator(pluginBinder, parentServiceLocator.getServiceLocator());
    }

    private <T extends Plugin> Try<PluginServiceLocator> createPluginServiceLocator(@NotNull PluginBinder<T> pluginBinder, @Nullable ServiceLocator parentServiceLocator) {
        return Try.of(() -> new PluginServiceLocator(pluginBinder, this.serviceLocatorFactory.create(pluginBinder.getPlugin().getName(), parentServiceLocator)));
    }

    private static final class ServerBinder
    extends AbstractBinder {
        private ServerBinder() {
        }

        @Override
        protected void configure() {
            this.bind(Bukkit.getServer()).to(Server.class);
            this.bind(Bukkit.getPluginManager()).to(PluginManager.class);
        }
    }
}

