/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.module.MultiverseModule;
import org.mvplugins.multiverse.core.utils.CoreLogging;

public final class MultiverseModulesRegistry {
    private static MultiverseModulesRegistry instance;
    private MultiverseCore core;
    private final List<String> registeredPlugins = new ArrayList<String>();
    private int pluginCount = 0;

    public static MultiverseModulesRegistry get() {
        if (instance == null) {
            instance = new MultiverseModulesRegistry();
        }
        return instance;
    }

    void registerMultiverseModule(MultiverseModule module) {
        if (module instanceof MultiverseCore) {
            this.core = (MultiverseCore)module;
            return;
        }
        if (this.core == null) {
            throw new IllegalStateException("MultiverseCore has not been initialized!");
        }
        CoreLogging.fine("Registering %s version api %s", module.getDescription().getName(), module.getVersionAsNumber());
        if (this.core.getVersionAsNumber() == -1.0) {
            return;
        }
        if (this.core.getVersionAsNumber() < module.getTargetCoreVersion()) {
            CoreLogging.severe("Your Multiverse-Core is OUT OF DATE!", new Object[0]);
            CoreLogging.severe("This version of %s requires at least Multiverse-Core version %s", module.getDescription().getName(), module.getTargetCoreVersion());
            CoreLogging.severe("Your current Multiverse-Core version is: %s", this.core.getVersionAsNumber());
            CoreLogging.severe("Grab an updated copy at: ", new Object[0]);
            CoreLogging.severe(this.core.getDescription().getWebsite(), new Object[0]);
            CoreLogging.severe("Disabling!", new Object[0]);
            this.core.getServer().getPluginManager().disablePlugin((Plugin)module);
            return;
        }
        this.registeredPlugins.add(module.getDescription().getName());
        ++this.pluginCount;
    }

    void unregisterMultiverseModule(MultiverseModule module) {
        if (module instanceof MultiverseCore) {
            this.core = null;
        }
        this.registeredPlugins.remove(module.getDescription().getName());
        --this.pluginCount;
    }

    MultiverseCore getCore() {
        return this.core;
    }

    public List<String> getRegisteredPlugins() {
        return Collections.unmodifiableList(this.registeredPlugins);
    }

    public int getPluginCount() {
        return this.pluginCount;
    }
}

