/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.permissions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.permissions.PermissionUtils;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
public final class CorePermissionsChecker {
    private final CoreConfig config;
    private final DestinationsProvider destinationsProvider;
    private final WorldManager worldManager;

    @Inject
    CorePermissionsChecker(@NotNull CoreConfig config, @NotNull DestinationsProvider destinationsProvider, @NotNull WorldManager worldManager) {
        this.config = config;
        this.destinationsProvider = destinationsProvider;
        this.worldManager = worldManager;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public boolean hasJoinLocationBypassPermission(@NotNull CommandSender sender) {
        return PermissionUtils.hasPermission(sender, "mv.bypass.joinlocation");
    }

    public boolean hasWorldAccessPermission(@NotNull CommandSender sender, @NotNull MultiverseWorld world) {
        return PermissionUtils.hasPermission(sender, PermissionUtils.concatPermission("multiverse.access", world.getName()));
    }

    public boolean hasWorldExemptPermission(@NotNull CommandSender sender, @NotNull MultiverseWorld world) {
        return PermissionUtils.hasPermission(sender, PermissionUtils.concatPermission("multiverse.exempt", world.getName()));
    }

    public boolean hasPlayerLimitBypassPermission(@NotNull CommandSender sender, @NotNull MultiverseWorld world) {
        return PermissionUtils.hasPermission(sender, PermissionUtils.concatPermission("mv.bypass.playerlimit", world.getName()));
    }

    public boolean hasGameModeBypassPermission(@NotNull CommandSender sender, @NotNull MultiverseWorld world) {
        return PermissionUtils.hasPermission(sender, PermissionUtils.concatPermission("mv.bypass.gamemode", world.getName()));
    }

    public boolean checkSpawnPermission(@NotNull CommandSender teleporter, @NotNull List<Entity> entities, @NotNull MultiverseWorld world) {
        return Scope.getApplicableScopes(teleporter, entities).stream().allMatch(scope -> this.checkSpawnPermission(teleporter, (Scope)((Object)scope), world));
    }

    public boolean checkSpawnPermission(@NotNull CommandSender teleporter, @NotNull Entity entity, @NotNull MultiverseWorld world) {
        return this.checkSpawnPermission(teleporter, Scope.getApplicableScope(teleporter, entity), world);
    }

    public boolean checkSpawnPermission(@NotNull CommandSender teleporter, @NotNull Scope scope, @NotNull MultiverseWorld world) {
        if (this.config.getUseFinerTeleportPermissions()) {
            return this.hasSpawnPermission(teleporter, scope, world);
        }
        return this.hasSpawnPermission(teleporter, scope, null);
    }

    public boolean hasAnySpawnPermission(@NotNull CommandSender sender) {
        return this.hasAnySpawnPermission(sender, Scope.values());
    }

    public boolean hasAnySpawnPermission(@NotNull CommandSender sender, @NotNull Scope scope) {
        return this.hasAnySpawnPermission(sender, new Scope[]{scope});
    }

    public boolean hasAnySpawnPermission(@NotNull CommandSender sender, @NotNull Scope[] scopes) {
        if (this.config.getUseFinerTeleportPermissions()) {
            return this.worldManager.getLoadedWorlds().stream().anyMatch(world -> Arrays.stream(scopes).anyMatch(scope -> this.hasSpawnPermission(sender, (Scope)((Object)((Object)scope)), (MultiverseWorld)world)));
        }
        return Arrays.stream(scopes).anyMatch(scope -> this.hasSpawnPermission(sender, (Scope)((Object)scope), null));
    }

    private boolean hasSpawnPermission(@NotNull CommandSender sender, @NotNull Scope scope, @Nullable MultiverseWorld world) {
        if (world == null) {
            return PermissionUtils.hasPermission(sender, PermissionUtils.concatPermission("multiverse.core.spawn", scope.getScope()));
        }
        return PermissionUtils.hasPermission(sender, PermissionUtils.concatPermission("multiverse.core.spawn", scope.getScope(), world.getName()));
    }

    public boolean checkDestinationPacketPermission(@NotNull CommandSender teleporter, @NotNull List<Entity> teleportees, @NotNull DestinationSuggestionPacket packet) {
        return Scope.getApplicableScopes(teleporter, teleportees).stream().allMatch(scope -> this.checkDestinationPacketPermission(teleporter, (Scope)((Object)scope), packet));
    }

    public boolean checkDestinationPacketPermission(@NotNull CommandSender teleporter, @NotNull Entity teleportee, @NotNull DestinationSuggestionPacket packet) {
        return this.checkDestinationPacketPermission(teleporter, Scope.getApplicableScope(teleporter, teleportee), packet);
    }

    public boolean checkDestinationPacketPermission(@NotNull CommandSender teleporter, @NotNull Scope scope, @NotNull DestinationSuggestionPacket packet) {
        return this.hasTeleportPermission(teleporter, scope, packet.destination().getIdentifier(), this.config.getUseFinerTeleportPermissions() ? packet.finerPermissionSuffix() : null);
    }

    public boolean checkTeleportPermission(@NotNull CommandSender teleporter, @NotNull List<Entity> teleportees, @NotNull DestinationInstance<?, ?> destination) {
        return Scope.getApplicableScopes(teleporter, teleportees).stream().allMatch(scope -> this.checkTeleportPermission(teleporter, (Scope)((Object)scope), destination));
    }

    public boolean checkTeleportPermission(@NotNull CommandSender teleporter, @NotNull Entity teleportee, @NotNull DestinationInstance<?, ?> destination) {
        return this.checkTeleportPermission(teleporter, Scope.getApplicableScope(teleporter, teleportee), destination);
    }

    public boolean checkTeleportPermission(@NotNull CommandSender teleporter, @NotNull Scope scope, @NotNull DestinationInstance<?, ?> destination) {
        if (this.config.getUseFinerTeleportPermissions()) {
            return this.hasTeleportPermission(teleporter, scope, destination.getIdentifier(), (String)destination.getFinerPermissionSuffix().getOrNull());
        }
        return this.hasTeleportPermission(teleporter, scope, destination.getIdentifier(), null);
    }

    public boolean hasAnyTeleportPermission(@NotNull CommandSender sender) {
        return this.hasAnyTeleportPermission(sender, Scope.values());
    }

    public boolean hasAnyTeleportPermission(@NotNull CommandSender sender, @NotNull Scope scope) {
        return this.hasAnyTeleportPermission(sender, new Scope[]{scope});
    }

    public boolean hasAnyTeleportPermission(@NotNull CommandSender sender, @NotNull Scope[] scopes) {
        if (!this.config.getUseFinerTeleportPermissions()) {
            for (Destination<?, ?, ?> destination : this.destinationsProvider.getDestinations()) {
                for (Scope scope : scopes) {
                    if (!this.hasTeleportPermission(sender, scope, destination.getIdentifier(), null)) continue;
                    return true;
                }
            }
            return false;
        }
        for (DestinationSuggestionPacket suggestion : this.destinationsProvider.suggestDestinations(sender, null)) {
            for (Scope scope : scopes) {
                if (!this.hasTeleportPermission(sender, scope, suggestion.destination().getIdentifier(), suggestion.finerPermissionSuffix())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasTeleportPermission(@NotNull CommandSender sender, @NotNull Scope scope, @NotNull String identifier, @Nullable String finerPermissionSuffix) {
        if (finerPermissionSuffix == null) {
            return PermissionUtils.hasPermission(sender, PermissionUtils.concatPermission("multiverse.teleport", scope.getScope(), identifier));
        }
        return PermissionUtils.hasPermission(sender, PermissionUtils.concatPermission("multiverse.teleport", scope.getScope(), identifier, finerPermissionSuffix));
    }

    public static enum Scope {
        SELF("self"),
        OTHER("other");

        private final String scope;

        private Scope(String scope) {
            this.scope = scope;
        }

        public String getScope() {
            return this.scope;
        }

        public String toString() {
            return this.scope;
        }

        public static Scope getApplicableScope(CommandSender teleporter, Entity entity) {
            Entity senderEntity;
            if (teleporter instanceof Entity && (senderEntity = (Entity)teleporter).equals((Object)entity)) {
                return SELF;
            }
            return OTHER;
        }

        public static List<Scope> getApplicableScopes(CommandSender sender, List<Entity> entities) {
            ArrayList<Scope> applicableScopes = new ArrayList<Scope>(Scope.values().length);
            if (sender instanceof Entity) {
                Entity entity = (Entity)sender;
                if (entities.contains(entity)) {
                    applicableScopes.add(SELF);
                }
                if (entities.stream().anyMatch(e -> !e.equals((Object)entity))) {
                    applicableScopes.add(OTHER);
                }
            } else {
                applicableScopes.add(OTHER);
            }
            return applicableScopes;
        }
    }
}

