/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.teleportation;

import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Vehicle;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.world.location.UnloadedWorldLocation;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public final class LocationManipulation {
    private static final Map<String, Integer> ORIENTATION_INTS = Map.ofEntries(Map.entry("n", 180), Map.entry("ne", 225), Map.entry("e", 270), Map.entry("se", 315), Map.entry("s", 0), Map.entry("sw", 45), Map.entry("w", 90), Map.entry("nw", 135), Map.entry("north", 180), Map.entry("northeast", 225), Map.entry("east", 270), Map.entry("southeast", 315), Map.entry("south", 0), Map.entry("southwest", 45), Map.entry("west", 90), Map.entry("northwest", 135));

    public String locationToString(Location location) {
        String worldName;
        if (location == null) {
            return "";
        }
        if (location instanceof UnloadedWorldLocation) {
            UnloadedWorldLocation unloadedWorldLocation = (UnloadedWorldLocation)location;
            v0 = unloadedWorldLocation.getWorldName();
        } else {
            v0 = worldName = (String)Try.of(() -> location.getWorld().getName()).getOrNull();
        }
        if (worldName == null) {
            return "";
        }
        return String.format(Locale.ENGLISH, "%s:%.2f,%.2f,%.2f:%.2f:%.2f", worldName, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
    }

    public Location getBlockLocation(Location l) {
        l.setX((double)l.getBlockX());
        l.setY((double)l.getBlockY());
        l.setZ((double)l.getBlockZ());
        return l;
    }

    @Nullable
    public Location stringToLocation(String locationString) {
        if (locationString == null) {
            return null;
        }
        String[] split = REPatterns.COLON.split(locationString);
        if (split.length < 2 || split.length > 4) {
            return null;
        }
        String[] xyzsplit = REPatterns.COMMA.split(split[1]);
        if (xyzsplit.length != 3) {
            return null;
        }
        String worldName = split[0];
        if (Strings.isNullOrEmpty((String)worldName)) {
            return null;
        }
        try {
            float pitch = 0.0f;
            float yaw = 0.0f;
            if (split.length >= 3) {
                yaw = (float)Double.parseDouble(split[2]);
            }
            if (split.length == 4) {
                pitch = (float)Double.parseDouble(split[3]);
            }
            return new UnloadedWorldLocation(worldName, Double.parseDouble(xyzsplit[0]), Double.parseDouble(xyzsplit[1]), Double.parseDouble(xyzsplit[2]), yaw, pitch);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String strCoords(Location l) {
        Object result = "";
        DecimalFormat df = new DecimalFormat();
        df.setMinimumFractionDigits(0);
        df.setMaximumFractionDigits(2);
        result = (String)result + String.valueOf(ChatColor.WHITE) + "X: " + String.valueOf(ChatColor.AQUA) + df.format(l.getX()) + " ";
        result = (String)result + String.valueOf(ChatColor.WHITE) + "Y: " + String.valueOf(ChatColor.AQUA) + df.format(l.getY()) + " ";
        result = (String)result + String.valueOf(ChatColor.WHITE) + "Z: " + String.valueOf(ChatColor.AQUA) + df.format(l.getZ()) + " ";
        result = (String)result + String.valueOf(ChatColor.WHITE) + "P: " + String.valueOf(ChatColor.GOLD) + df.format(l.getPitch()) + " ";
        result = (String)result + String.valueOf(ChatColor.WHITE) + "Y: " + String.valueOf(ChatColor.GOLD) + df.format(l.getYaw()) + " ";
        return result;
    }

    public String strCoordsRaw(Location l) {
        if (l == null) {
            return "null";
        }
        Object result = "";
        DecimalFormat df = new DecimalFormat();
        df.setMinimumFractionDigits(0);
        df.setMaximumFractionDigits(2);
        result = (String)result + "X: " + df.format(l.getX()) + " ";
        result = (String)result + "Y: " + df.format(l.getY()) + " ";
        result = (String)result + "Z: " + df.format(l.getZ()) + " ";
        result = (String)result + "P: " + df.format(l.getPitch()) + " ";
        result = (String)result + "Y: " + df.format(l.getYaw()) + " ";
        return result;
    }

    public String getDirection(Location location) {
        double r = location.getYaw() % 360.0f + 180.0f;
        String dir = r < 22.5 ? "n" : (r < 67.5 ? "ne" : (r < 112.5 ? "e" : (r < 157.5 ? "se" : (r < 202.5 ? "s" : (r < 247.5 ? "sw" : (r < 292.5 ? "w" : (r < 337.5 ? "nw" : "n")))))));
        return dir;
    }

    public float getYaw(String orientation) {
        if (orientation == null) {
            return 0.0f;
        }
        if (ORIENTATION_INTS.containsKey(orientation.toLowerCase())) {
            return ORIENTATION_INTS.get(orientation.toLowerCase()).intValue();
        }
        return 0.0f;
    }

    public float getSpeed(Vector v) {
        return (float)Math.sqrt(v.getX() * v.getX() + v.getZ() * v.getZ());
    }

    public Vector getTranslatedVector(Vector v, String direction) {
        if (direction == null) {
            return v;
        }
        float speed = this.getSpeed(v);
        float halfSpeed = (float)((double)speed / 2.0);
        if (direction.equalsIgnoreCase("n")) {
            return new Vector(0.0f, 0.0f, -1.0f * speed);
        }
        if (direction.equalsIgnoreCase("ne")) {
            return new Vector(halfSpeed, 0.0f, -1.0f * halfSpeed);
        }
        if (direction.equalsIgnoreCase("e")) {
            return new Vector(speed, 0.0f, 0.0f);
        }
        if (direction.equalsIgnoreCase("se")) {
            return new Vector(halfSpeed, 0.0f, halfSpeed);
        }
        if (direction.equalsIgnoreCase("s")) {
            return new Vector(0.0f, 0.0f, speed);
        }
        if (direction.equalsIgnoreCase("sw")) {
            return new Vector(-1.0f * halfSpeed, 0.0f, halfSpeed);
        }
        if (direction.equalsIgnoreCase("w")) {
            return new Vector(-1.0f * speed, 0.0f, 0.0f);
        }
        if (direction.equalsIgnoreCase("nw")) {
            return new Vector(-1.0f * halfSpeed, 0.0f, -1.0f * halfSpeed);
        }
        return v;
    }

    public Location getNextBlock(Vehicle v) {
        int x;
        Vector vector = v.getVelocity();
        Location location = v.getLocation();
        int n = vector.getX() < 0.0 ? (vector.getX() == 0.0 ? 0 : -1) : (x = 1);
        int z = vector.getZ() < 0.0 ? (vector.getZ() == 0.0 ? 0 : -1) : 1;
        return location.add((double)x, 0.0, (double)z);
    }
}

