/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.result;

import java.util.function.Consumer;
import java.util.function.Function;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.core.utils.result.SuccessReason;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Result<S extends SuccessReason, F extends FailureReason> {
    public static <F extends FailureReason, S extends SuccessReason> Result<S, F> success(S successReason, MessageReplacement ... replacements) {
        return new Success(successReason, replacements);
    }

    public static <F extends FailureReason, S extends SuccessReason> Result<S, F> success(S successReason, Message message) {
        return new Success(successReason, message);
    }

    public static <F extends FailureReason, S extends SuccessReason> Result<S, F> failure(F failureReason, MessageReplacement ... replacements) {
        return new Failure(failureReason, replacements);
    }

    public static <F extends FailureReason, S extends SuccessReason> Result<S, F> failure(F failureReason, Message message) {
        return new Failure(failureReason, message);
    }

    public boolean isSuccess();

    public boolean isFailure();

    public S getSuccessReason();

    public F getFailureReason();

    @NotNull
    public Message getReasonMessage();

    default public Result<S, F> onSuccess(Consumer<Success<S, F>> consumer) {
        if (this instanceof Success) {
            consumer.accept((Success)this);
        }
        return this;
    }

    default public Result<S, F> onFailure(Consumer<Failure<S, F>> consumer) {
        if (this instanceof Failure) {
            consumer.accept((Failure)this);
        }
        return this;
    }

    default public Result<S, F> onSuccessReason(S successReason, Consumer<S> consumer) {
        if (this.isSuccess() && this.getSuccessReason() == successReason) {
            consumer.accept(this.getSuccessReason());
        }
        return this;
    }

    default public Result<S, F> onFailureReason(F failureReason, Consumer<F> consumer) {
        if (this.isFailure() && this.getFailureReason() == failureReason) {
            consumer.accept(this.getFailureReason());
        }
        return this;
    }

    default public Result<S, F> onSuccessThen(Function<Success<S, F>, Result<S, F>> function) {
        if (this instanceof Success) {
            return function.apply((Success)this);
        }
        return this;
    }

    default public Result<S, F> onFailureThen(Function<Failure<S, F>, Result<S, F>> function) {
        if (this instanceof Failure) {
            return function.apply((Failure)this);
        }
        return this;
    }

    default public <R> R fold(Function<Failure<S, F>, R> failureFunc, Function<Success<S, F>, R> successFunc) {
        if (this instanceof Failure) {
            return failureFunc.apply((Failure)this);
        }
        if (this instanceof Success) {
            return successFunc.apply((Success)this);
        }
        throw new IllegalStateException("Unknown result type: " + this.getClass().getName());
    }

    public static final class Success<S extends SuccessReason, F extends FailureReason>
    implements Result<S, F> {
        private final S successReason;
        private final Message message;

        Success(S successReason, Message message) {
            this.successReason = successReason;
            this.message = message;
        }

        Success(S successReason, MessageReplacement[] replacements) {
            this.successReason = successReason;
            this.message = Message.of(successReason, "Success!", replacements);
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public S getSuccessReason() {
            return this.successReason;
        }

        @Override
        public F getFailureReason() {
            throw new UnsupportedOperationException("No reason for success");
        }

        @Override
        @NotNull
        public Message getReasonMessage() {
            return this.message;
        }

        public String toString() {
            return "Success{reason=" + String.valueOf(this.successReason) + "}";
        }
    }

    public static final class Failure<S extends SuccessReason, F extends FailureReason>
    implements Result<S, F> {
        private final F failureReason;
        private final Message message;

        Failure(F failureReason, Message message) {
            this.failureReason = failureReason;
            this.message = message;
        }

        Failure(F failureReason, MessageReplacement[] replacements) {
            this.failureReason = failureReason;
            this.message = Message.of(failureReason, "Failed!", replacements);
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public S getSuccessReason() {
            throw new UnsupportedOperationException("No reason for failure");
        }

        @Override
        public F getFailureReason() {
            return this.failureReason;
        }

        @Override
        @NotNull
        public Message getReasonMessage() {
            return this.message;
        }

        public String toString() {
            return "Failure{reason=" + String.valueOf(this.failureReason) + "}";
        }
    }
}

