/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.util;

import ch.ethz.globis.phtree.util.MinHeapI;
import ch.ethz.globis.phtree.util.StringBuilderLn;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class MinHeap<T>
implements MinHeapI<T> {
    private static final int DEFAULT_SIZE = 16;
    private T[] data;
    private int size = 0;
    private final Less<T> less;

    private MinHeap(int capacity, Less<T> lessFn) {
        this.data = new Object[capacity];
        this.less = lessFn;
    }

    public static <T extends Comparable<T>> MinHeap<T> create() {
        return new MinHeap(16, new LessWrapper(Comparable::compareTo));
    }

    public static <T> MinHeap<T> create(Less<T> less) {
        return new MinHeap<T>(16, less);
    }

    private boolean hasChildren(int i) {
        return i * 2 <= this.size;
    }

    private void swap(int i1, int i2) {
        T v = this.data[i1];
        this.data[i1] = this.data[i2];
        this.data[i2] = v;
    }

    private int parent(int i) {
        return i >> 1;
    }

    private boolean hasParent(int i) {
        return i >> 1 > 0;
    }

    private int indexOfSmallestChild(int index) {
        int start = index * 2;
        int end = this.end();
        if (start + 1 < end) {
            return start + (this.less.less(this.data[start], this.data[start + 1]) ? 0 : 1);
        }
        return start;
    }

    private void pushDown(int m) {
        while (this.hasChildren(m)) {
            int i = m;
            if (this.less.less(this.data[m = this.indexOfSmallestChild(i)], this.data[i])) {
                this.swap(m, i);
                continue;
            }
            return;
        }
    }

    private void pushUp(int index, T value) {
        this.pushUpMin(index, value);
    }

    private void pushUpMin(int index, T value) {
        while (this.hasParent(index) && this.less.less(value, this.data[this.parent(index)])) {
            this.data[index] = this.data[this.parent(index)];
            index = this.parent(index);
        }
        this.data[index] = value;
    }

    private int end() {
        return this.size + 1;
    }

    @Override
    public void push(T value) {
        if (this.size == 0) {
            this.data[1] = value;
            ++this.size;
            return;
        }
        if (this.size + 1 >= this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        ++this.size;
        this.pushUp(this.size, value);
    }

    @Override
    public void popMin() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int end = this.end();
        T value = this.data[end - 1];
        this.data[end - 1] = null;
        --this.size;
        if (this.size == 0) {
            return;
        }
        this.data[1] = value;
        this.pushDown(1);
    }

    @Override
    public T peekMin() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        return this.data[1];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public String print() {
        StringBuilderLn s = new StringBuilderLn();
        int x = 2;
        for (int i = 1; i <= this.size; ++i) {
            if (i % x == 0) {
                s.appendLn();
                x *= 2;
            }
            s.append(this.data[i] + "   ");
        }
        s.appendLn();
        return s.toString();
    }

    @Override
    public void clear() {
        this.size = 0;
        if (this.data.length > 16) {
            this.data = new Object[16];
        } else {
            Arrays.fill(this.data, null);
        }
    }

    static class LessWrapper<C>
    implements Less<C> {
        private final Comparator<C> comp;

        LessWrapper(Comparator<C> comp) {
            this.comp = comp;
        }

        @Override
        public boolean less(C o1, C o2) {
            return this.comp.compare(o1, o2) < 0;
        }
    }

    @FunctionalInterface
    public static interface Less<T> {
        public boolean less(T var1, T var2);
    }
}

