/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.v16.Node;
import ch.ethz.globis.phtree.v16.PhTree16;
import ch.ethz.globis.phtree.v16.bst.BSTIteratorAll;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class PhQueryKnnHS<T>
implements PhTree.PhKnnQuery<T> {
    private static final PhDEComp COMP = new PhDEComp();
    private final int dims;
    private PhTree16<T> pht;
    private PhDistance distance;
    private long[] center;
    private final ArrayList<PhEntryDist<T>> results = new ArrayList();
    private final ArrayList<PhEntryDist<Object>> pool = new ArrayList();
    private final PriorityQueue<PhEntryDist<Object>> queue = new PriorityQueue(COMP);
    private final BSTIteratorAll iterNode = new BSTIteratorAll();
    private Iterator<PhEntryDist<T>> iterResult;

    public PhQueryKnnHS(PhTree16<T> pht) {
        this.dims = pht.getDim();
        this.pht = pht;
    }

    @Override
    public long[] nextKey() {
        return ((PhEntry)this.nextEntryReuse()).getKey();
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public PhEntryDist<T> nextEntry() {
        return this.iterResult.next();
    }

    @Override
    public PhEntryDist<T> nextEntryReuse() {
        return this.iterResult.next();
    }

    @Override
    public boolean hasNext() {
        return this.iterResult.hasNext();
    }

    @Override
    public T next() {
        return this.nextValue();
    }

    @Override
    public PhTree.PhKnnQuery<T> reset(int nMin, PhDistance dist, long ... center) {
        this.distance = dist == null ? this.distance : dist;
        this.center = center;
        this.queue.clear();
        this.results.clear();
        if (nMin <= 0 || this.pht.size() == 0) {
            this.iterResult = Collections.emptyIterator();
            return this;
        }
        PhEntryDist<Object> rootE = this.createEntry(new long[this.dims], this.pht.getRoot(), 0.0);
        this.queue.add(rootE);
        this.search(nMin);
        this.iterResult = this.results.iterator();
        return this;
    }

    private void search(int k) {
        while (!this.queue.isEmpty()) {
            PhEntryDist<Object> candidate = this.queue.poll();
            Object o = candidate.getValue();
            if (!(o instanceof Node)) {
                this.results.add(candidate);
                if (this.results.size() < k) continue;
                return;
            }
            Node node = (Node)o;
            this.iterNode.reset(node.getRoot());
            while (this.iterNode.hasNextEntry()) {
                Node.BSTEntry e2 = this.iterNode.nextEntry();
                if (e2.getValue() instanceof Node) {
                    Node sub = (Node)e2.getValue();
                    double d = this.distToNode(e2.getKdKey(), sub.getPostLen() + 1);
                    this.queue.add(this.createEntry(e2.getKdKey(), e2.getValue(), d));
                    continue;
                }
                double d = this.distance.dist(this.center, e2.getKdKey());
                this.queue.add(this.createEntry(e2.getKdKey(), e2.getValue(), d));
            }
            this.pool.add(candidate);
        }
    }

    private PhEntryDist<Object> createEntry(long[] key, Object val, double dist) {
        if (this.pool.isEmpty()) {
            return new PhEntryDist<Object>(key, val, dist);
        }
        PhEntryDist<Object> e = this.pool.remove(this.pool.size() - 1);
        e.setKeyInternal(key);
        e.set(val, dist);
        return e;
    }

    private double distToNode(long[] prefix, int bitsToIgnore) {
        long maskMin = -1L << bitsToIgnore;
        long maskMax = maskMin ^ 0xFFFFFFFFFFFFFFFFL;
        long[] buf = new long[prefix.length];
        for (int i = 0; i < buf.length; ++i) {
            long min = prefix[i] & maskMin;
            long max = prefix[i] | maskMax;
            buf[i] = min > this.center[i] ? min : (max < this.center[i] ? max : this.center[i]);
        }
        return this.distance.dist(this.center, buf);
    }

    private static class PhDEComp
    implements Comparator<PhEntryDist<?>> {
        private PhDEComp() {
        }

        @Override
        public int compare(PhEntryDist<?> a, PhEntryDist<?> b) {
            double d2;
            double d1 = a.dist();
            return d1 < (d2 = b.dist()) ? -1 : (d1 > d2 ? 1 : 0);
        }
    }
}

