/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity;

import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.Position;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;
        private static final MethodHandle HURT = NMS.getMethodHandle(EntityEnderDragon.class, "c", true, List.class);
        private static final MethodHandle KNOCKBACK = NMS.getMethodHandle(EntityEnderDragon.class, "b", true, List.class);

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level) {
            this(types, level, null);
        }

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public void b_() {
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                this.npc.update();
            }
            if (this.npc != null && !this.npc.useMinecraftAI()) {
                if (this.ep()) {
                    this.c(0.0f);
                    return;
                }
                if (this.d < 0) {
                    for (int i = 0; i < this.c.length; ++i) {
                        this.c[i][0] = this.dw();
                        this.c[i][1] = this.dn();
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.dw();
                this.c[this.d][1] = this.dn();
                float[][] pos = NMS.calculateDragonPositions(this.dw(), new double[][]{this.a(0, 1.0f), this.a(5, 1.0f), this.a(10, 1.0f), this.a(12, 1.0f), this.a(14, 1.0f), this.a(16, 1.0f)});
                for (int j = 0; j < this.ce.length; ++j) {
                    Vec3D vec3 = new Vec3D(this.ce[j].dl(), this.ce[j].dn(), this.ce[j].dr());
                    this.ce[j].e(this.dl() + (double)pos[j][0], this.dn() + (double)pos[j][1], this.dr() + (double)pos[j][2]);
                    this.ce[j].I = this.ce[j].ab = vec3.c;
                    this.ce[j].J = this.ce[j].ac = vec3.d;
                    this.ce[j].K = this.ce[j].ad = vec3.e;
                }
                if (this.cN() != null) {
                    this.f(this.cN().getBukkitYaw() - 180.0f);
                }
                Vec3D mot = this.dj();
                if (mot.c != 0.0 || mot.d != 0.0 || mot.e != 0.0) {
                    mot = mot.d(0.98, 0.91, 0.98);
                    if (this.cN() == null) {
                        this.f(Util.getYawFromVelocity((Entity)this.getBukkitEntity(), mot.c, mot.e));
                    }
                    this.e(this.dl() + mot.c, this.dn() + mot.d, this.dr() + mot.e);
                    this.f(mot);
                }
                if (this.npc.hasTrait(EnderDragonTrait.class) && this.npc.getOrAddTrait(EnderDragonTrait.class).isDestroyWalls() && NMSImpl.ENDERDRAGON_CHECK_WALLS != null) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.bT |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.ce[i].cD());
                            continue;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(false)).booleanValue()) {
                    try {
                        KNOCKBACK.invoke(this, this.H.a((net.minecraft.world.entity.Entity)this, this.ce[6].cD().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        KNOCKBACK.invoke(this, this.H.a((net.minecraft.world.entity.Entity)this, this.ce[7].cD().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        HURT.invoke(this, this.H.a((net.minecraft.world.entity.Entity)this, this.ce[0].cD().g(1.0), IEntitySelector.e));
                        HURT.invoke(this, this.H.a((net.minecraft.world.entity.Entity)this, this.ce[1].cD().g(1.0), IEntitySelector.e));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                super.b_();
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean l(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.l(entity);
        }

        public void ds() {
            if (this.npc == null) {
                super.ds();
            }
        }

        protected SoundEffect s() {
            return NMSImpl.getSoundEffect(this.npc, super.s(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect x_() {
            return NMSImpl.getSoundEffect(this.npc, super.x_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect d(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float eQ() {
            return NMS.getJumpPower(this.npc, super.eQ());
        }

        public int cp() {
            return NMS.getFallDistance(this.npc, super.cp());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction C_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.C_();
        }

        public boolean fI() {
            return NMSImpl.isLeashed(this.npc, () -> super.fI(), (EntityInsentient)this);
        }

        public boolean bn() {
            return this.npc == null ? super.bn() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void q(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.q((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB am() {
            return NMSBoundingBox.makeBB(this.npc, super.am());
        }

        public void j(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.j(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected boolean g(DamageSource source, float f) {
            if (this.npc == null) {
                return super.g(source, f);
            }
            Vec3D old = this.dj();
            boolean res = super.g(source, f);
            if (this.fP().a().i() == DragonControllerPhase.k) {
                this.f(old);
            }
            return res;
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dj().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.f(old);
            }
            return res;
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entity);
        }
    }
}

