/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level) {
            this(types, level, null);
        }

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public void m_() {
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                this.npc.update();
            }
            if (this.npc != null && !this.npc.useMinecraftAI()) {
                if (this.ex()) {
                    this.v(0.0f);
                    return;
                }
                if (this.d < 0) {
                    for (int i = 0; i < this.c.length; ++i) {
                        this.c[i][0] = this.dE();
                        this.c[i][1] = this.dv();
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.dE();
                this.c[this.d][1] = this.dv();
                float[][] pos = NMS.calculateDragonPositions(this.dE(), new double[][]{this.a(0, 1.0f), this.a(5, 1.0f), this.a(10, 1.0f), this.a(12, 1.0f), this.a(14, 1.0f), this.a(16, 1.0f)});
                for (int j = 0; j < this.co.length; ++j) {
                    Vec3D vec3 = new Vec3D(this.co[j].dt(), this.co[j].dv(), this.co[j].dz());
                    this.co[j].a_(this.dt() + (double)pos[j][0], this.dv() + (double)pos[j][1], this.dz() + (double)pos[j][2]);
                    this.co[j].L = this.co[j].ad = vec3.c;
                    this.co[j].M = this.co[j].ae = vec3.d;
                    this.co[j].N = this.co[j].af = vec3.e;
                }
                if (this.cT() != null) {
                    this.t(this.cT().getBukkitYaw() - 180.0f);
                }
                Vec3D mot = this.dr();
                if (mot.c != 0.0 || mot.d != 0.0 || mot.e != 0.0) {
                    mot = mot.d(0.98, 0.91, 0.98);
                    if (this.cT() == null) {
                        this.t(Util.getYawFromVelocity((Entity)this.getBukkitEntity(), mot.c, mot.e));
                    }
                    this.a_(this.dt() + mot.c, this.dv() + mot.d, this.dz() + mot.e);
                    this.i(mot);
                }
                if (this.npc.hasTrait(EnderDragonTrait.class) && this.npc.getOrAddTrait(EnderDragonTrait.class).isDestroyWalls() && NMSImpl.ENDERDRAGON_CHECK_WALLS != null) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.cd |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.co[i].cK());
                            continue;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(false)).booleanValue()) {
                    try {
                        NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.dO(), this.dO().a((net.minecraft.world.entity.Entity)this, this.co[6].cK().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.dO(), this.dO().a((net.minecraft.world.entity.Entity)this, this.co[7].cK().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_HURT.invoke(this, this.dO().a((net.minecraft.world.entity.Entity)this, this.co[0].cK().g(1.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_HURT.invoke(this, this.dO().a((net.minecraft.world.entity.Entity)this, this.co[1].cK().g(1.0), IEntitySelector.e));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                super.m_();
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public net.minecraft.world.entity.Entity a(DimensionTransition transition) {
            if (this.npc == null) {
                return super.a(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void dA() {
            if (this.npc == null) {
                super.dA();
            }
        }

        protected SoundEffect v() {
            return NMSImpl.getSoundEffect(this.npc, super.v(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect n_() {
            return NMSImpl.getSoundEffect(this.npc, super.n_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect d(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fd() {
            return NMS.getJumpPower(this.npc, super.fd());
        }

        public int cx() {
            return NMS.getFallDistance(this.npc, super.cx());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction j_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.j_();
        }

        public boolean N_() {
            return NMSImpl.isLeashed(this.npc, () -> super.N_(), (EntityInsentient)this);
        }

        public boolean bB() {
            return this.npc == null ? super.bB() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB au() {
            return NMSBoundingBox.makeBB(this.npc, super.au());
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected boolean g(DamageSource source, float f) {
            if (this.npc == null) {
                return super.g(source, f);
            }
            Vec3D old = this.dr();
            boolean res = super.g(source, f);
            if (this.gh().a().i() == DragonControllerPhase.k) {
                this.i(old);
            }
            return res;
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dr().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entity);
        }
    }
}

