/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_21_R1.network.EmptyConnection;
import net.citizensnpcs.nms.v1_21_R1.network.EmptyPacketListener;
import net.citizensnpcs.nms.v1_21_R1.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_21_R1.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_21_R1.util.MobAI;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity,
MobAI.ForwardingMobAI {
    private AdvancementDataPlayer advancements;
    private final MobAI ai;
    private int jumpTicks = 0;
    private final CitizensNPC npc;
    private boolean setBukkitEntity;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTER = NMS.getFirstMethodHandle(PlayerInteractManager.class, true, EnumGamemode.class, EnumGamemode.class);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, ClientInformation ci, NPC npc) {
        super(minecraftServer, world, gameProfile, ci);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.ai = new MobAI.BasicMobAI((EntityLiving)this);
            this.skinTracker = new SkinPacketTracker(this);
            try {
                GAMEMODE_SETTER.invoke(this.e, EnumGamemode.a, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.initialise(minecraftServer, ci);
        } else {
            this.ai = null;
            this.skinTracker = null;
        }
    }

    public boolean a(EntityPlayer player) {
        return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
    }

    public boolean a(float f, float f1, DamageSource damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.a(f, f1, damagesource);
        }
        return false;
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    public void a(DamageSource damagesource) {
        if (this.be) {
            return;
        }
        super.a(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> {
            ((WorldServer)this.dO()).a((EntityPlayer)this, Entity.RemovalReason.a);
            ((WorldServer)this.dO()).l().a((net.minecraft.world.entity.Entity)this);
        }, 15L);
    }

    public void m() {
        boolean navigating;
        if (this.npc == null) {
            super.m();
            return;
        }
        super.aw();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.ai.getMoveControl().b();
        if (!(navigating || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !this.npc.getOrAddTrait(Gravity.class).hasGravity() || !Util.isLoaded(this.getBukkitEntity().getLocation()) || this.npc.isProtected() && !SpigotUtil.checkYSafe(this.dv(), this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(Vec3D.b);
        }
        Vec3D mot = this.dr();
        if (Math.abs(mot.c) < (double)0.003f && Math.abs(mot.d) < (double)0.003f && Math.abs(mot.e) < (double)0.003f) {
            this.i(Vec3D.b);
        }
        if (navigating) {
            if (!this.ai.getNavigation().l()) {
                this.ai.getNavigation().c();
            }
            this.moveOnCurrentHeading();
        }
        this.tickAI();
        this.ag = this.R_();
        if (this.R_()) {
            this.aG = false;
        }
        this.r();
        if (this.npc.useMinecraftAI()) {
            this.ce.a((EntityHuman)this);
        }
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(false)).booleanValue()) {
            if (this.ci > 0) {
                --this.ci;
            }
            AxisAlignedBB axisalignedbb = this.bS() && !this.dc().dJ() ? this.cK().b(this.dc().cK()).c(1.0, 0.0, 1.0) : this.cK().c(1.0, 0.5, 1.0);
            for (net.minecraft.world.entity.Entity entity : this.dO().a_((net.minecraft.world.entity.Entity)this, axisalignedbb)) {
                entity.b_((EntityHuman)this);
            }
        }
        ++this.aT;
        this.gt().a();
        if (!this.npc.hasTrait(EntityPoseTrait.class) || this.npc.getTraitNullable(EntityPoseTrait.class).getPose() == null) {
            this.fR();
        }
    }

    public AdvancementDataPlayer R() {
        if (this.npc == null) {
            return super.R();
        }
        if (this.advancements == null) {
            this.advancements = new EmptyAdvancementDataPlayer(this.cO().aD(), this.cO().ah(), this);
        }
        return this.advancements;
    }

    @Override
    public MobAI getAI() {
        return this.ai;
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !this.setBukkitEntity) {
            NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PlayerNPC(this));
            this.setBukkitEntity = true;
        }
        return super.getBukkitEntity();
    }

    protected SoundEffect n_() {
        return NMSImpl.getSoundEffect(this.npc, super.n_(), NPC.Metadata.DEATH_SOUND);
    }

    protected SoundEffect d(DamageSource damagesource) {
        return NMSImpl.getSoundEffect(this.npc, super.d(damagesource), NPC.Metadata.HURT_SOUND);
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public GameProfile getProfile() {
        return super.fX();
    }

    @Override
    public String getSkinName() {
        String skinName = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public ServerStatisticManager I() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public IChatBaseComponent O() {
        if (this.npc != null && this.npc.shouldRemoveFromTabList()) {
            return IChatMutableComponent.a((ComponentContents)new LiteralContents.a(""));
        }
        return this.npc != null ? (IChatBaseComponent)Messaging.minecraftComponentFromRawMessage(this.npc.getRawName()) : super.O();
    }

    public boolean a(DamageSource damagesource, float f) {
        boolean damaged = super.a(damagesource, f);
        if (damaged && this.U) {
            this.U = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                this.U = true;
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer, ClientInformation clientInfo) {
        try {
            EmptyConnection conn = new EmptyConnection(EnumProtocolDirection.b);
            this.c = new EmptyPacketListener(minecraftServer, conn, this, new CommonListenerCookie(this.getProfile(), 0, clientInfo, false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.am = 0;
        this.setSkinFlags((byte)-1);
    }

    public boolean bF() {
        if (this.npc == null || this.ag || this.fH()) {
            return super.bF();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean bB() {
        return this.npc == null ? super.bB() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
    }

    public void p(double strength, double dx, double dz) {
        NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
    }

    private void moveOnCurrentHeading() {
        if (this.bn) {
            if (this.aG && this.jumpTicks == 0) {
                this.ff();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bo *= 0.98f;
        this.bq *= 0.98f;
        this.moveWithFallDamage(new Vec3D((double)this.bo, (double)this.bp, (double)this.bq));
        NMS.setHeadAndBodyYaw((Entity)this.getBukkitEntity(), this.dE());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3D vec) {
        double x = this.dt();
        double y = this.dv();
        double z = this.dz();
        this.a(vec);
        if (!this.npc.isProtected()) {
            this.a(this.dt() - x, this.dv() - y, this.dz() - z, this.aG);
        }
    }

    public boolean p_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.p_();
        }
        return false;
    }

    public void h(net.minecraft.world.entity.Entity entity) {
        super.h(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.R().b();
    }

    @Override
    public void setSkinFlags(byte flags) {
        this.ar().a(EntityHuman.bX, (Object)flags);
    }

    @Override
    public void setSkinName(String name) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name);
    }

    @Override
    public void setSkinName(String name, boolean forceUpdate) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name, forceUpdate);
    }

    @Override
    public void setSkinPersistent(String skinName, String signature, String data) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(skinName, signature, data);
    }

    public void l() {
        super.l();
        if (this.npc == null) {
            return;
        }
        this.detectEquipmentUpdatesPublic();
        float scale = this.eb();
        if (scale != this.bG) {
            this.bG = scale;
            this.i_();
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
        if (NMSImpl.PAPER_PLAYER_MOB_COUNTS != null && this.npc.shouldRemoveFromPlayerList()) {
            try {
                int[] counts = NMSImpl.PAPER_PLAYER_MOB_COUNTS.invoke(this);
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = 0;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void tickAI() {
        this.ai.getMoveControl().a();
        this.ai.getJumpControl().b();
    }

    public void a(Vec3D vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(vec3d);
        } else {
            NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
        }
    }

    public boolean a(TagKey<FluidType> tagkey, double d0) {
        Vec3D old = this.dr().b(0.0, 0.0, 0.0);
        boolean res = super.a(tagkey, d0);
        if (!this.npc.isPushableByFluids()) {
            this.i(old);
        }
        return res;
    }

    private void updatePackets(boolean navigating) {
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.cb = true;
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType().name().contains("ITEM_FRAME")) {
                return false;
            }
            return super.canSee(entity);
        }

        @Override
        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        @Override
        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        @Override
        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        @Override
        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        @Override
        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

