/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftGlowSquid;
import org.bukkit.entity.Entity;
import org.bukkit.entity.GlowSquid;

public class GlowSquidController
extends MobEntityController {
    public GlowSquidController() {
        super(EntityGlowSquidNPC.class);
    }

    public GlowSquid getBukkitEntity() {
        return (GlowSquid)super.getBukkitEntity();
    }

    public static class EntityGlowSquidNPC
    extends net.minecraft.world.entity.GlowSquid
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityGlowSquidNPC(EntityTypes<? extends net.minecraft.world.entity.GlowSquid> types, World level) {
            this(types, level, null);
        }

        public EntityGlowSquidNPC(EntityTypes<? extends net.minecraft.world.entity.GlowSquid> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public boolean a(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public net.minecraft.world.entity.Entity a(DimensionTransition transition) {
            if (this.npc == null) {
                return super.a(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void dA() {
            if (this.npc == null) {
                super.dA();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void ab() {
            super.ab();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                this.npc.update();
            }
        }

        protected SoundEffect v() {
            return NMSImpl.getSoundEffect(this.npc, super.v(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new GlowSquidNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect n_() {
            return NMSImpl.getSoundEffect(this.npc, super.n_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect d(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fd() {
            return NMS.getJumpPower(this.npc, super.fd());
        }

        public int cx() {
            return NMS.getFallDistance(this.npc, super.cx());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction j_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.j_();
        }

        public boolean N_() {
            return NMSImpl.isLeashed(this.npc, () -> super.N_(), (EntityInsentient)this);
        }

        public boolean bB() {
            return this.npc == null ? super.bB() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB au() {
            return NMSBoundingBox.makeBB(this.npc, super.au());
        }

        public boolean p_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.p_();
            }
            return false;
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void i_() {
            if (this.npc == null) {
                super.i_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.an);
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public void a(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(vec3d);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dr().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class GlowSquidNPC
    extends CraftGlowSquid
    implements ForwardingNPCHolder {
        public GlowSquidNPC(EntityGlowSquidNPC entity) {
            super((CraftServer)Bukkit.getServer(), (net.minecraft.world.entity.GlowSquid)entity);
        }
    }
}

