/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPufferFish;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PufferFish;

public class PufferFishController
extends MobEntityController {
    public PufferFishController() {
        super(EntityPufferFishNPC.class);
    }

    public PufferFish getBukkitEntity() {
        return (PufferFish)super.getBukkitEntity();
    }

    public static class EntityPufferFishNPC
    extends EntityPufferFish
    implements NPCHolder {
        private final CitizensNPC npc;
        private ControllerMove oldMoveController;

        public EntityPufferFishNPC(EntityTypes<? extends EntityPufferFish> types, World level) {
            this(types, level, null);
        }

        public EntityPufferFishNPC(EntityTypes<? extends EntityPufferFish> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.oldMoveController = this.bT;
                this.bT = new ControllerMove((EntityInsentient)this);
            }
        }

        public void m_() {
            boolean lastInWater = this.R;
            int lastPuffState = this.gm();
            if (this.npc != null) {
                this.R = false;
                this.c(0);
            }
            super.m_();
            if (this.npc != null) {
                this.R = lastInWater;
                this.c(lastPuffState);
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public boolean a(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public net.minecraft.world.entity.Entity a(DimensionTransition transition) {
            if (this.npc == null) {
                return super.a(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void dA() {
            if (this.npc == null) {
                super.dA();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void ab() {
            super.ab();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.bT != this.oldMoveController) {
                    this.bT = this.oldMoveController;
                }
                if (!this.npc.useMinecraftAI() && this.bT == this.oldMoveController) {
                    this.bT = new EntityMoveControl((EntityLiving)this);
                }
                this.npc.update();
            }
        }

        protected SoundEffect v() {
            return NMSImpl.getSoundEffect(this.npc, super.v(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PufferFishNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect n_() {
            return NMSImpl.getSoundEffect(this.npc, super.n_(), NPC.Metadata.DEATH_SOUND);
        }

        public EntitySize e(EntityPose entitypose) {
            if (this.npc == null) {
                return super.e(entitypose);
            }
            return super.e(entitypose).a(1.0f / EntityPufferFishNPC.s(this.gm())).a(0.5f);
        }

        protected SoundEffect d(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fd() {
            return NMS.getJumpPower(this.npc, super.fd());
        }

        public int cx() {
            return NMS.getFallDistance(this.npc, super.cx());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction j_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.j_();
        }

        public boolean N_() {
            return NMSImpl.isLeashed(this.npc, () -> super.N_(), (EntityInsentient)this);
        }

        public boolean bB() {
            return this.npc == null ? super.bB() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB au() {
            return NMSBoundingBox.makeBB(this.npc, super.au());
        }

        protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.b(entityhuman, enumhand);
            }
            ItemStack itemstack = entityhuman.b(enumhand);
            if (itemstack.g() == Items.qz && this.bE()) {
                return EnumInteractionResult.f;
            }
            return super.b(entityhuman, enumhand);
        }

        public boolean p_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.p_();
            }
            return false;
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public void l() {
            if (this.npc != null) {
                NMSImpl.resetPuffTicks(this);
            }
            super.l();
            PufferFishTrait trait = null;
            if (this.npc != null && (trait = this.npc.getTraitNullable(PufferFishTrait.class)) != null) {
                this.c(trait.getPuffState());
            }
        }

        public void a(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                if (!NMSImpl.moveFish(this.npc, (EntityInsentient)this, vec3d)) {
                    super.a(vec3d);
                }
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dr().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }

        private static float s(int i) {
            switch (i) {
                case 0: {
                    return 0.5f;
                }
                case 1: {
                    return 0.7f;
                }
            }
            return 1.0f;
        }
    }

    public static class PufferFishNPC
    extends CraftPufferFish
    implements ForwardingNPCHolder {
        public PufferFishNPC(EntityPufferFishNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPufferFish)entity);
        }
    }
}

