/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class BoatController
extends MobEntityController {
    public BoatController() {
        super(EntityBoatNPC.class);
    }

    public Boat getBukkitEntity() {
        return (Boat)super.getBukkitEntity();
    }

    public static class EntityBoatNPC
    extends EntityBoat
    implements NPCHolder {
        private float invFriction;
        private float landFriction;
        private EntityBoat.EnumStatus lastStatus;
        private final CitizensNPC npc;
        private EntityBoat.EnumStatus status;
        private double waterLevel;

        public EntityBoatNPC(EntityTypes<? extends EntityBoat> types, World level) {
            this(types, level, null);
        }

        public EntityBoatNPC(EntityTypes<? extends EntityBoat> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        public net.minecraft.world.entity.Entity a(DimensionTransition transition) {
            if (this.npc == null) {
                return super.a(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        private boolean checkInWater() {
            AxisAlignedBB axisalignedbb = this.cK();
            int i = MathHelper.a((double)axisalignedbb.a);
            int j = MathHelper.c((double)axisalignedbb.d);
            int k = MathHelper.a((double)axisalignedbb.b);
            int l = MathHelper.c((double)(axisalignedbb.b + 0.001));
            int i1 = MathHelper.a((double)axisalignedbb.c);
            int j1 = MathHelper.c((double)axisalignedbb.f);
            boolean flag = false;
            this.waterLevel = -1.7976931348623157E308;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.d(k1, l1, i2);
                        Fluid fluid = this.dO().b_((BlockPosition)blockposition_mutableblockposition);
                        if (!fluid.a(TagsFluid.a)) continue;
                        float f = (float)l1 + fluid.a((IBlockAccess)this.dO(), (BlockPosition)blockposition_mutableblockposition);
                        this.waterLevel = Math.max((double)f, this.waterLevel);
                        flag |= axisalignedbb.b < (double)f;
                    }
                }
            }
            return flag;
        }

        private void floatBoat() {
            double d0 = -this.ba();
            double d1 = 0.0;
            this.invFriction = 0.05f;
            if (this.lastStatus == EntityBoat.EnumStatus.e && this.status != EntityBoat.EnumStatus.e && this.status != EntityBoat.EnumStatus.d) {
                this.waterLevel = this.e(1.0);
                double d2 = (double)(this.t() - this.dk()) + 0.101;
                if (this.dO().a((net.minecraft.world.entity.Entity)this, this.cK().d(0.0, d2 - this.dv(), 0.0))) {
                    this.a(EnumMoveType.a, new Vec3D(0.0, d2 - this.dv(), 0.0));
                    this.i(this.dr().d(1.0, 0.0, 1.0));
                }
                this.status = EntityBoat.EnumStatus.a;
            } else {
                if (this.status == EntityBoat.EnumStatus.a) {
                    d1 = (this.waterLevel - this.dv()) / (double)this.dk();
                    this.invFriction = 0.9f;
                } else if (this.status == EntityBoat.EnumStatus.c) {
                    d0 = -7.0E-4;
                    this.invFriction = 0.9f;
                } else if (this.status == EntityBoat.EnumStatus.b) {
                    d1 = 0.01f;
                    this.invFriction = 0.45f;
                } else if (this.status == EntityBoat.EnumStatus.e) {
                    this.invFriction = 0.9f;
                } else if (this.status == EntityBoat.EnumStatus.d) {
                    this.invFriction = this.landFriction;
                    if (this.cQ() instanceof Player) {
                        this.landFriction /= 2.0f;
                    }
                }
                Vec3D vec3d = this.dr();
                this.n(vec3d.c * (double)this.invFriction, vec3d.d + d0, vec3d.e * (double)this.invFriction);
                if (d1 > 0.0) {
                    Vec3D vec3d1 = this.dr();
                    this.n(vec3d1.c, (vec3d1.d + d1 * (this.aZ() / 0.65)) * 0.75, vec3d1.e);
                }
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new BoatNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction j_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.j_();
        }

        private EntityBoat.EnumStatus getStatus() {
            EntityBoat.EnumStatus entityboat_Status = this.isUnderwater();
            if (entityboat_Status != null) {
                this.waterLevel = this.cK().e;
                return entityboat_Status;
            }
            if (this.checkInWater()) {
                return EntityBoat.EnumStatus.a;
            }
            float f = this.v();
            if (f > 0.0f) {
                this.landFriction = f;
                return EntityBoat.EnumStatus.d;
            }
            return EntityBoat.EnumStatus.e;
        }

        public boolean bB() {
            return this.npc == null ? super.bB() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        private EntityBoat.EnumStatus isUnderwater() {
            AxisAlignedBB axisalignedbb = this.cK();
            double d0 = axisalignedbb.e + 0.001;
            int i = MathHelper.a((double)axisalignedbb.a);
            int j = MathHelper.c((double)axisalignedbb.d);
            int k = MathHelper.a((double)axisalignedbb.e);
            int l = MathHelper.c((double)d0);
            int i1 = MathHelper.a((double)axisalignedbb.c);
            int j1 = MathHelper.c((double)axisalignedbb.f);
            boolean flag = false;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.d(k1, l1, i2);
                        Fluid fluid = this.dO().b_((BlockPosition)blockposition_mutableblockposition);
                        if (!fluid.a(TagsFluid.a) || !(d0 < (double)((float)blockposition_mutableblockposition.v() + fluid.a((IBlockAccess)this.dO(), (BlockPosition)blockposition_mutableblockposition)))) continue;
                        if (!fluid.b()) {
                            return EntityBoat.EnumStatus.c;
                        }
                        flag = true;
                    }
                }
            }
            return flag ? EntityBoat.EnumStatus.b : null;
        }

        protected AxisAlignedBB au() {
            return NMSBoundingBox.makeBB(this.npc, super.au());
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void i_() {
            if (this.npc == null) {
                super.i_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.an);
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public void l() {
            if (this.npc != null) {
                this.aw();
                if (this.cQ() instanceof NPCHolder && ((NPCHolder)this.cQ()).getNPC().getNavigator().isNavigating()) {
                    this.i(this.cQ().dr().d(20.0, 0.0, 20.0));
                }
                this.npc.update();
                if (this.O() > 0) {
                    this.d(this.O() - 1);
                }
                if (this.N() > 0.0f) {
                    this.b(this.N() - 1.0f);
                }
                this.lastStatus = this.status;
                this.status = this.getStatus();
                this.floatBoat();
                this.a(EnumMoveType.a, this.dr());
                this.aT();
            } else {
                super.l();
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dr().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class BoatNPC
    extends CraftBoat
    implements ForwardingNPCHolder {
        public BoatNPC(EntityBoatNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityBoat)entity);
        }
    }
}

