/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.util;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_21_R1.util.EntityNodeEvaluator;
import net.citizensnpcs.nms.v1_21_R1.util.EntityPathfinder;
import net.citizensnpcs.nms.v1_21_R1.util.MobAI;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;

public class EntityNavigation
extends NavigationAbstract {
    private boolean avoidSun;
    private final AttributeModifiable followRange;
    protected boolean m;
    private boolean isStuck;
    protected int f;
    protected Vec3D g = Vec3D.b;
    protected long j;
    protected float l = 0.5f;
    private float maxVisitedNodesMultiplier = 1.0f;
    private final EntityLiving mob;
    private final MobAI mvmt;
    protected EntityNodeEvaluator nodeEvaluator;
    protected PathEntity c;
    private final EntityPathfinder pathFinder;
    private int reachRange;
    protected double d;
    private BlockPosition targetPos;
    protected int e;
    protected long n;
    protected BaseBlockPosition h = BaseBlockPosition.g;
    protected double k;
    protected long i;

    public EntityNavigation(EntityLiving entityinsentient, World world) {
        super((EntityInsentient)new EntitySlime(EntityTypes.aP, world), world);
        this.mob = entityinsentient;
        this.mvmt = MobAI.from((Entity)entityinsentient);
        this.followRange = entityinsentient.f(GenericAttributes.m);
        this.nodeEvaluator = new EntityNodeEvaluator();
        this.nodeEvaluator.a(true);
        this.pathFinder = new EntityPathfinder(this.nodeEvaluator, Settings.Setting.MAXIMUM_VISITED_NODES.asInt());
    }

    public boolean b(PathType pathtype) {
        return pathtype != PathType.n && pathtype != PathType.g && pathtype != PathType.p && pathtype != PathType.d;
    }

    public boolean p() {
        return this.nodeEvaluator.f();
    }

    protected boolean a(Vec3D var0, Vec3D var1) {
        return false;
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.d();
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.d();
    }

    protected boolean a() {
        return this.mob.aF() || this.mob.bj() || this.mob.bS();
    }

    public PathEntity a(BlockPosition var0, int var1) {
        BlockPosition var3;
        Chunk var2 = this.b.N().a(SectionPosition.a((int)var0.u()), SectionPosition.a((int)var0.w()));
        if (var2 == null) {
            return null;
        }
        if (var2.a_(var0).i()) {
            var3 = var0.e();
            while (var3.v() > this.b.I_() && var2.a_(var3).i()) {
                var3 = var3.e();
            }
            if (var3.v() > this.b.I_()) {
                return this.supercreatePath(var3.d(), var1);
            }
            while (var3.v() < this.b.am() && var2.a_(var3).i()) {
                var3 = var3.d();
            }
            var0 = var3;
        }
        if (!var2.a_(var0).e()) {
            return this.supercreatePath(var0, var1);
        }
        var3 = var0.d();
        while (var3.v() < this.b.am() && var2.a_(var3).e()) {
            var3 = var3.d();
        }
        return this.supercreatePath(var3, var1);
    }

    public PathEntity a(BlockPosition var0, int var1, int var2) {
        return this.a((Set<BlockPosition>)ImmutableSet.of((Object)var0), 8, false, var1, var2);
    }

    public PathEntity a(Entity var0, int var1) {
        return this.a(var0.do(), var1);
    }

    public PathEntity a(Set<BlockPosition> var0, int var1) {
        return this.a(var0, 8, false, var1);
    }

    protected PathEntity a(Set<BlockPosition> var0, int var1, boolean var2, int reachRange) {
        return this.a(var0, var1, var2, reachRange, (float)this.followRange.f());
    }

    protected PathEntity a(Set<BlockPosition> var0, int var1, boolean headAbove, int reachRange, float range) {
        int blockRange;
        if (var0.isEmpty() || this.mob.dv() < (double)this.b.I_() || !this.a()) {
            return null;
        }
        if (this.c != null && !this.c.c() && var0.contains(this.targetPos)) {
            return this.c;
        }
        BlockPosition headPos = headAbove ? this.mob.do().d() : this.mob.do();
        ChunkCache region = new ChunkCache(this.b, headPos.b(-(blockRange = (int)(range + (float)var1)), -blockRange, -blockRange), headPos.b(blockRange, blockRange, blockRange));
        PathEntity var8 = this.pathFinder.findPath(region, this.mob, var0, range, reachRange, this.maxVisitedNodesMultiplier);
        if (var8 != null && var8.l() != null) {
            this.targetPos = var8.l();
            this.reachRange = reachRange;
            this.resetStuckTimeout();
        }
        return var8;
    }

    public PathEntity a(Stream<BlockPosition> var0, int var1) {
        return this.a(var0.collect(Collectors.toSet()), 8, false, var1);
    }

    protected Pathfinder a(int paramInt) {
        return null;
    }

    protected void b(Vec3D var0) {
        if (this.e - this.f > 100) {
            float var1 = this.mob.fj() >= 1.0f ? this.mob.fj() : this.mob.fj() * this.mob.fj();
            float var2 = var1 * 100.0f * 0.25f;
            if (var0.g(this.g) < (double)(var2 * var2)) {
                this.isStuck = true;
                this.n();
            } else {
                this.isStuck = false;
            }
            this.f = this.e;
            this.g = var0;
        }
        if (this.c != null && !this.c.c()) {
            BlockPosition var1 = this.c.g();
            long var2 = this.b.Z();
            if (var1.equals((Object)this.h)) {
                this.i += var2 - this.j;
            } else {
                this.h = var1;
                double var4 = var0.f(Vec3D.c((BaseBlockPosition)this.h));
                double d = this.k = this.mob.fj() > 0.0f ? var4 / (double)this.mob.fj() * 20.0 : 0.0;
            }
            if (this.k > 0.0 && (double)this.i > this.k * 3.0) {
                this.timeoutPath();
            }
            this.j = var2;
        }
    }

    protected void k() {
        boolean var8;
        Vec3D var0 = this.b();
        this.l = this.mob.dj() > 0.75f ? this.mob.dj() / 2.0f : 0.75f - this.mob.dj() / 2.0f;
        BlockPosition var1 = this.c.g();
        double var2 = Math.abs(this.mob.dt() - ((double)var1.u() + 0.5));
        double var4 = Math.abs(this.mob.dv() - (double)var1.v());
        double var6 = Math.abs(this.mob.dz() - ((double)var1.w() + 0.5));
        boolean bl = var8 = var2 < (double)this.l && var6 < (double)this.l && var4 < 1.0;
        if (var8 || this.b(this.c.h().l) && this.shouldTargetNextNodeInDirection(var0)) {
            this.c.a();
        }
        this.b(var0);
    }

    protected double a(Vec3D var0) {
        BlockPosition var1 = BlockPosition.a((IPosition)var0);
        return this.b.a_(var1.e()).i() ? var0.d : PathfinderNormal.a((IBlockAccess)this.b, (BlockPosition)var1);
    }

    public float q() {
        return this.l;
    }

    public PathfinderAbstract o() {
        return this.nodeEvaluator;
    }

    public PathEntity j() {
        return this.c;
    }

    public PathEntity getPathEntity() {
        return this.c;
    }

    private int getSurfaceY() {
        if (this.mob.bf() && this.p()) {
            int var0 = this.mob.du();
            IBlockData var1 = this.b.a_(BlockPosition.a((double)this.mob.dt(), (double)var0, (double)this.mob.dz()));
            int var2 = 0;
            do {
                if (!var1.a(Blocks.G)) {
                    return var0;
                }
                var1 = this.b.a_(BlockPosition.a((double)this.mob.dt(), (double)(++var0), (double)this.mob.dz()));
            } while (++var2 <= 16);
            return this.mob.du();
        }
        return MathHelper.a((double)(this.mob.dv() + 0.5));
    }

    public BlockPosition h() {
        return this.targetPos;
    }

    protected Vec3D b() {
        return new Vec3D(this.mob.dt(), (double)this.getSurfaceY(), this.mob.dz());
    }

    protected boolean hasValidPathType(PathType var0) {
        if (var0 == PathType.j || var0 == PathType.i) {
            return false;
        }
        return var0 != PathType.b;
    }

    public boolean l() {
        return this.c == null || this.c.c();
    }

    public boolean m() {
        return !this.l();
    }

    public boolean a(BlockPosition var0) {
        BlockPosition var1 = var0.e();
        return this.b.a_(var1).i((IBlockAccess)this.b, var1);
    }

    public boolean r() {
        return this.isStuck;
    }

    public boolean a(double var0, double var2, double var4, double var6) {
        return this.a(this.a(BlockPosition.a((double)var0, (double)var2, (double)var4), 1), var6);
    }

    public boolean a(Entity var0, double var1) {
        PathEntity var3 = this.a(var0, 1);
        return var3 != null && this.a(var3, var1);
    }

    public boolean a(PathEntity var0, double var1) {
        if (var0 == null) {
            this.c = null;
            return false;
        }
        if (!var0.a(this.c)) {
            this.c = var0;
        }
        if (this.l()) {
            return false;
        }
        this.W_();
        if (this.c.e() <= 0) {
            return false;
        }
        this.d = var1;
        Vec3D var3 = this.b();
        this.f = this.e;
        this.g = var3;
        return true;
    }

    public void i() {
        if (this.b.Z() - this.n > 20L) {
            if (this.targetPos != null) {
                this.c = null;
                this.c = this.a(this.targetPos, this.reachRange);
                this.n = this.b.Z();
                this.m = false;
            }
        } else {
            this.m = true;
        }
    }

    public void g() {
        this.maxVisitedNodesMultiplier = 1.0f;
    }

    private void resetStuckTimeout() {
        this.h = BaseBlockPosition.g;
        this.i = 0L;
        this.k = 0.0;
        this.isStuck = false;
    }

    public void setAvoidSun(boolean var0) {
        this.avoidSun = var0;
    }

    public void a(boolean var0) {
        this.nodeEvaluator.c(var0);
    }

    public void setCanOpenDoors(boolean var0) {
        this.nodeEvaluator.b(var0);
    }

    public void setCanPassDoors(boolean var0) {
        this.nodeEvaluator.a(var0);
    }

    public void a(float var0) {
        this.maxVisitedNodesMultiplier = var0;
    }

    public void a(double var0) {
        this.d = var0;
    }

    public boolean b(BlockPosition var0) {
        if (this.m || this.c == null || this.c.c() || this.c.e() == 0) {
            return false;
        }
        PathPoint var1 = this.c.d();
        Vec3D var2 = new Vec3D(((double)var1.a + this.mob.dt()) / 2.0, ((double)var1.b + this.mob.dv()) / 2.0, ((double)var1.c + this.mob.dz()) / 2.0);
        return var0.a((IPosition)var2, (double)(this.c.e() - this.c.f()));
    }

    private boolean shouldTargetNextNodeInDirection(Vec3D var0) {
        boolean var10;
        if (this.c.f() + 1 >= this.c.e()) {
            return false;
        }
        Vec3D var1 = Vec3D.c((BaseBlockPosition)this.c.g());
        if (!var0.a((IPosition)var1, 2.0)) {
            return false;
        }
        if (this.a(var0, this.c.a((Entity)this.mob))) {
            return true;
        }
        Vec3D var2 = Vec3D.c((BaseBlockPosition)this.c.d(this.c.f() + 1));
        Vec3D var3 = var1.d(var0);
        Vec3D var4 = var2.d(var0);
        double var5 = var3.g();
        double var7 = var4.g();
        boolean var9 = var7 < var5;
        boolean bl = var10 = var5 < 0.5;
        if (!var9 && !var10) {
            return false;
        }
        Vec3D var11 = var3.d();
        Vec3D var12 = var4.d();
        return var12.b(var11) < 0.0;
    }

    public void n() {
        this.c = null;
    }

    public PathEntity supercreatePath(BlockPosition var0, int var1) {
        return this.a((Set<BlockPosition>)ImmutableSet.of((Object)var0), 8, false, var1);
    }

    protected void supertrimPath() {
        if (this.c == null) {
            return;
        }
        for (int var0 = 0; var0 < this.c.e(); ++var0) {
            PathPoint var1 = this.c.a(var0);
            PathPoint var2 = var0 + 1 < this.c.e() ? this.c.a(var0 + 1) : null;
            IBlockData var3 = this.b.a_(new BlockPosition(var1.a, var1.b, var1.c));
            if (!var3.a(TagsBlock.bm)) continue;
            this.c.a(var0, var1.a(var1.a, var1.b + 1, var1.c));
            if (var2 == null || var1.b < var2.b) continue;
            this.c.a(var0 + 1, var1.a(var2.a, var1.b + 1, var2.c));
        }
    }

    public void c() {
        ++this.e;
        if (this.m) {
            this.i();
        }
        if (!this.l()) {
            Vec3D var0;
            if (this.a()) {
                this.k();
            } else if (this.c != null && !this.c.c()) {
                var0 = this.b();
                Vec3D var1 = this.c.a((Entity)this.mob);
                if (var0.d > var1.d && !this.mob.aF() && MathHelper.a((double)var0.c) == MathHelper.a((double)var1.c) && MathHelper.a((double)var0.e) == MathHelper.a((double)var1.e)) {
                    this.c.a();
                }
            }
            if (!this.l()) {
                var0 = this.c.a((Entity)this.mob);
                this.mvmt.getMoveControl().a(var0.c, this.a(var0), var0.e, this.d);
            }
        }
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.n();
    }

    protected void W_() {
        this.supertrimPath();
        if (this.avoidSun) {
            if (this.b.h(BlockPosition.a((double)this.mob.dt(), (double)(this.mob.dv() + 0.5), (double)this.mob.dz()))) {
                return;
            }
            for (int var0 = 0; var0 < this.c.e(); ++var0) {
                PathPoint var1 = this.c.a(var0);
                if (!this.b.h(new BlockPosition(var1.a, var1.b, var1.c))) continue;
                this.c.b(var0);
                return;
            }
        }
    }
}

