/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;

@TraitName(value="pausepathfinding")
public class PausePathfindingTrait
extends Trait {
    @Persist(value="pauseticks")
    private int pauseTicks;
    @Persist(value="playerrange")
    private double playerRange = -1.0;
    @Persist(value="rightclick")
    private boolean rightclick;
    private int unpauseTaskId = -1;

    public PausePathfindingTrait() {
        super("pausepathfinding");
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteract(NPCRightClickEvent event) {
        if (!this.rightclick || event.getNPC() != this.npc) {
            return;
        }
        this.pause();
        event.setDelayedCancellation(true);
    }

    private void pause() {
        if (this.unpauseTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.unpauseTaskId);
        }
        this.npc.getNavigator().cancelNavigation();
        this.npc.getNavigator().setPaused(true);
        this.unpauseTaskId = Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            NMS.setPitch(this.npc.getEntity(), 0.0f);
            this.npc.getNavigator().setPaused(false);
        }, this.pauseTicks <= 0 ? 20L : (long)this.pauseTicks);
    }

    @Override
    public void run() {
        if (this.playerRange == -1.0 || !this.npc.isSpawned() || this.unpauseTaskId == -1 && !this.npc.getNavigator().isNavigating()) {
            return;
        }
        if (CitizensAPI.getLocationLookup().getNearbyVisiblePlayers(this.npc.getEntity(), this.npc.getStoredLocation(), this.playerRange).iterator().hasNext()) {
            this.pause();
        }
    }

    public void setPauseTicks(int pauseTicks) {
        this.pauseTicks = pauseTicks;
    }

    public void setPlayerRangeBlocks(double range) {
        this.playerRange = range;
    }

    public void setRightClick(boolean rightclick) {
        this.rightclick = rightclick;
    }
}

