/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.text.TextBasePrompt;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@TraitName(value="text")
public class Text
extends Trait
implements Runnable,
Listener {
    private final Map<UUID, Long> cooldowns = Maps.newHashMap();
    private int currentIndex;
    @Persist
    private int delay = -1;
    @Persist(value="talkitem")
    private String itemInHandPattern = "default";
    @Persist(value="random-talker")
    private boolean randomTalker = Settings.Setting.DEFAULT_RANDOM_TALKER.asBoolean();
    private double range = Settings.Setting.DEFAULT_TALK_CLOSE_RANGE.asDouble();
    @Persist(value="realistic-looking")
    private boolean realisticLooker = Settings.Setting.DEFAULT_REALISTIC_LOOKING.asBoolean();
    @Persist(value="send-text-to-chat")
    private boolean sendTextToChat = true;
    @Persist(value="speech-bubble-duration")
    private int speechBubbleDuration = Settings.Setting.DEFAULT_TEXT_SPEECH_BUBBLE_DURATION.asTicks();
    @Persist(value="speech-bubbles")
    private boolean speechBubbles;
    @Persist(value="talk-close")
    private boolean talkClose = Settings.Setting.DEFAULT_TALK_CLOSE.asBoolean();
    @Persist
    private final List<String> text = new ArrayList<String>();
    private static final Random RANDOM = Util.getFastRandom();

    public Text() {
        super("text");
    }

    public void add(String string) {
        this.text.add(string);
    }

    public void edit(int index, String newText) {
        this.text.set(index, newText);
    }

    public Editor getEditor(final Player player) {
        final Conversation conversation = new ConversationFactory(CitizensAPI.getPlugin()).withLocalEcho(false).withEscapeSequence("/npc text").withEscapeSequence("exit").withModality(false).withFirstPrompt((Prompt)new TextBasePrompt(this)).buildConversation((Conversable)player);
        return new Editor(){

            @Override
            public void begin() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.text.begin", new Object[0]);
                conversation.begin();
            }

            @Override
            public void end() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.text.end", new Object[0]);
                conversation.abandon();
            }
        };
    }

    String getPageText(int page) {
        Paginator paginator = new Paginator().header("Current Texts");
        for (int i = 0; i < this.text.size(); ++i) {
            paginator.addLine("<green>" + i + " <gray>- <yellow>" + this.text.get(i));
        }
        return paginator.getPageText(page);
    }

    public List<String> getTexts() {
        return this.text;
    }

    public boolean hasIndex(int index) {
        return index >= 0 && this.text.size() > index;
    }

    boolean hasPage(int page) {
        return new Paginator(this.text.size()).hasPage(page);
    }

    public boolean isRandomTalker() {
        return this.randomTalker;
    }

    @Override
    public void load(DataKey key) {
        this.range = key.getDouble("range", Settings.Setting.DEFAULT_TALK_CLOSE_RANGE.asDouble());
    }

    @EventHandler
    private void onRightClick(NPCRightClickEvent event) {
        String localPattern;
        if (!event.getNPC().equals(this.npc) || this.text.size() == 0) {
            return;
        }
        String string = localPattern = "default".equals(this.itemInHandPattern) ? Settings.Setting.TALK_ITEM.asString() : this.itemInHandPattern;
        if (Util.matchesItemInHand(event.getClicker(), localPattern) && !this.shouldTalkClose()) {
            this.talk(event.getClicker());
            event.setDelayedCancellation(true);
        }
    }

    @Override
    public void onSpawn() {
        if (this.text.isEmpty()) {
            this.text.addAll(Settings.Setting.DEFAULT_TEXT.asList());
        }
    }

    public void remove(int index) {
        this.text.remove(index);
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !this.talkClose || this.text.size() == 0) {
            return;
        }
        for (Player player : CitizensAPI.getLocationLookup().getNearbyVisiblePlayers(this.npc.getEntity(), this.range)) {
            this.talk(player);
        }
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("range");
        if (this.range != Settings.Setting.DEFAULT_TALK_CLOSE_RANGE.asDouble()) {
            key.setDouble("range", this.range);
        }
    }

    boolean sendPage(CommandSender player, int page) {
        Paginator paginator = new Paginator().header("Current Texts").enablePageSwitcher("/npc text page $page");
        for (int i = 0; i < this.text.size(); ++i) {
            paginator.addLine(this.text.get(i) + " <green>(<click:suggest_command:edit " + i + " ><yellow>edit</click>) (<hover:show_text:Remove this text><click:run_command:/npc text remove " + i + "><red>-</click></hover>)");
        }
        return paginator.sendPage(player, page);
    }

    private boolean sendText(Player player) {
        if (this.text.size() == 0) {
            return false;
        }
        int index = 0;
        if (this.randomTalker) {
            index = RANDOM.nextInt(this.text.size());
        } else {
            if (this.currentIndex > this.text.size() - 1) {
                this.currentIndex = 0;
            }
            index = this.currentIndex++;
        }
        if (this.speechBubbles) {
            HologramTrait trait = this.npc.getOrAddTrait(HologramTrait.class);
            trait.addTemporaryLine(Placeholders.replace(this.text.get(index), (CommandSender)player, this.npc), this.speechBubbleDuration);
        }
        if (this.sendTextToChat) {
            this.npc.getDefaultSpeechController().speak(new SpeechContext(this.text.get(index), (Entity)player));
        }
        return true;
    }

    public boolean sendTextToChat() {
        return this.sendTextToChat;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setItemInHandPattern(String pattern) {
        this.itemInHandPattern = pattern;
    }

    public void setRange(double range) {
        this.range = range;
    }

    public void setSpeechBubbleDuration(Duration duration) {
        this.speechBubbleDuration = (int)(duration.get(ChronoUnit.MILLIS) / 50L);
    }

    public boolean shouldTalkClose() {
        return this.talkClose;
    }

    private void talk(Player player) {
        int delay;
        Long cooldown = this.cooldowns.get(player.getUniqueId());
        if (cooldown != null) {
            if (System.currentTimeMillis() < cooldown) {
                return;
            }
            this.cooldowns.remove(player.getUniqueId());
        }
        this.sendText(player);
        int n = delay = this.delay == -1 ? Settings.Setting.DEFAULT_TEXT_DELAY_MIN.asTicks() + Util.getFastRandom().nextInt(Settings.Setting.DEFAULT_TEXT_DELAY_MAX.asTicks() - Settings.Setting.DEFAULT_TEXT_DELAY_MIN.asTicks()) : this.delay;
        if (delay <= 0) {
            return;
        }
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis() + (long)(delay * 50));
    }

    public boolean toggleRandomTalker() {
        this.randomTalker = !this.randomTalker;
        return this.randomTalker;
    }

    public boolean toggleRealisticLooking() {
        this.realisticLooker = !this.realisticLooker;
        return this.realisticLooker;
    }

    public boolean toggleSendTextToChat() {
        this.sendTextToChat = !this.sendTextToChat;
        return this.sendTextToChat;
    }

    public boolean toggleSpeechBubbles() {
        this.speechBubbles = !this.speechBubbles;
        return this.speechBubbles;
    }

    public boolean toggleTalkClose() {
        this.talkClose = !this.talkClose;
        return this.talkClose;
    }

    public boolean useRealisticLooking() {
        return this.realisticLooker;
    }

    public boolean useSpeechBubbles() {
        return this.speechBubbles;
    }
}

