/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity;

import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends net.minecraft.world.entity.boss.enderdragon.EnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;
        private static final MethodHandle HURT = NMS.getMethodHandle(net.minecraft.world.entity.boss.enderdragon.EnderDragon.class, "c", true, List.class);
        private static final MethodHandle KNOCKBACK = NMS.getMethodHandle(net.minecraft.world.entity.boss.enderdragon.EnderDragon.class, "b", true, List.class);

        public EntityEnderDragonNPC(EntityType<? extends net.minecraft.world.entity.boss.enderdragon.EnderDragon> types, Level level) {
            this(types, level, null);
        }

        public EntityEnderDragonNPC(EntityType<? extends net.minecraft.world.entity.boss.enderdragon.EnderDragon> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public void b_() {
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (Mob)this);
                this.npc.update();
            }
            if (this.npc != null && !this.npc.useMinecraftAI()) {
                if (this.canBeSeenAsEnemy()) {
                    this.heal(0.0f);
                    return;
                }
                if (this.posPointer < 0) {
                    for (int i = 0; i < this.positions.length; ++i) {
                        this.positions[i][0] = this.dw();
                        this.positions[i][1] = this.dn();
                    }
                }
                if (++this.posPointer == this.positions.length) {
                    this.posPointer = 0;
                }
                this.positions[this.posPointer][0] = this.dw();
                this.positions[this.posPointer][1] = this.dn();
                float[][] pos = NMS.calculateDragonPositions(this.dw(), new double[][]{this.getLatencyPos(0, 1.0f), this.getLatencyPos(5, 1.0f), this.getLatencyPos(10, 1.0f), this.getLatencyPos(12, 1.0f), this.getLatencyPos(14, 1.0f), this.getLatencyPos(16, 1.0f)});
                for (int j = 0; j < this.ce.length; ++j) {
                    Vec3 vec3 = new Vec3(this.ce[j].dl(), this.ce[j].dn(), this.ce[j].dr());
                    this.ce[j].moveTo(this.dl() + (double)pos[j][0], this.dn() + (double)pos[j][1], this.dr() + (double)pos[j][2]);
                    this.ce[j].I = this.ce[j].ab = vec3.x;
                    this.ce[j].J = this.ce[j].ac = vec3.y;
                    this.ce[j].K = this.ce[j].xOld = vec3.z;
                }
                if (this.cN() != null) {
                    this.playSwimSound(this.cN().getBukkitYaw() - 180.0f);
                }
                Vec3 mot = this.dj();
                if (mot.x != 0.0 || mot.y != 0.0 || mot.z != 0.0) {
                    mot = mot.multiply(0.98, 0.91, 0.98);
                    if (this.cN() == null) {
                        this.playSwimSound(Util.getYawFromVelocity((Entity)this.getBukkitEntity(), mot.x, mot.z));
                    }
                    this.moveTo(this.dl() + mot.x, this.dn() + mot.y, this.dr() + mot.z);
                    this.moveTo(mot);
                }
                if (this.npc.hasTrait(EnderDragonTrait.class) && this.npc.getOrAddTrait(EnderDragonTrait.class).isDestroyWalls() && NMSImpl.ENDERDRAGON_CHECK_WALLS != null) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.bT |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.ce[i].cD());
                            continue;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(false)).booleanValue()) {
                    try {
                        KNOCKBACK.invoke(this, this.H.getEntities((net.minecraft.world.entity.Entity)this, this.ce[6].cD().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        KNOCKBACK.invoke(this, this.H.getEntities((net.minecraft.world.entity.Entity)this, this.ce[7].cD().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        HURT.invoke(this, this.H.getEntities((net.minecraft.world.entity.Entity)this, this.ce[0].cD().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        HURT.invoke(this, this.H.getEntities((net.minecraft.world.entity.Entity)this, this.ce[1].cD().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                super.b_();
            }
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        protected boolean l(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof Boat || entity instanceof AbstractMinecart)) {
                return !this.npc.isProtected();
            }
            return super.l(entity);
        }

        public void ds() {
            if (this.npc == null) {
                super.ds();
            }
        }

        protected SoundEvent s() {
            return NMSImpl.getSoundEffect(this.npc, super.s(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEvent x_() {
            return NMSImpl.getSoundEffect(this.npc, super.x_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEvent getHurtSound(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getHurtSound(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float eQ() {
            return NMS.getJumpPower(this.npc, super.eQ());
        }

        public int cp() {
            return NMS.getFallDistance(this.npc, super.cp());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction C_() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.C_();
        }

        public boolean fI() {
            return NMSImpl.isLeashed(this.npc, () -> super.fI(), (Mob)this);
        }

        public boolean bn() {
            return this.npc == null ? super.bn() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void q(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.q((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AABB am() {
            return NMSBoundingBox.makeBB(this.npc, super.am());
        }

        public void push(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.push(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected boolean reallyHurt(DamageSource source, float f) {
            if (this.npc == null) {
                return super.reallyHurt(source, f);
            }
            Vec3 old = this.dj();
            boolean res = super.reallyHurt(source, f);
            if (this.fP().getCurrentPhase().getPhase() == EnderDragonPhase.HOVERING) {
                this.moveTo(old);
            }
            return res;
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(ServerLevel worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.dj().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.moveTo(old);
            }
            return res;
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (net.minecraft.world.entity.boss.enderdragon.EnderDragon)entity);
        }
    }
}

