/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_19_R3.network.EmptyNetHandler;
import net.citizensnpcs.nms.v1_19_R3.network.EmptyNetworkManager;
import net.citizensnpcs.nms.v1_19_R3.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_19_R3.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_19_R3.util.MobAI;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends ServerPlayer
implements NPCHolder,
SkinnableEntity,
MobAI.ForwardingMobAI {
    private PlayerAdvancements advancements;
    private MobAI ai;
    private int jumpTicks = 0;
    private final CitizensNPC npc;
    private boolean setBukkitEntity;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTING = NMS.getFirstMethodHandle(ServerPlayerGameMode.class, true, GameType.class, GameType.class);
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public EntityHumanNPC(MinecraftServer minecraftServer, ServerLevel world, GameProfile gameProfile, NPC npc) {
        super(minecraftServer, world, gameProfile);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.ai = new MobAI.BasicMobAI((LivingEntity)this);
            this.skinTracker = new SkinPacketTracker(this);
            try {
                GAMEMODE_SETTING.invoke(this.d, GameType.SURVIVAL, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.initialise(minecraftServer);
        } else {
            this.skinTracker = null;
        }
    }

    public boolean broadcastToPlayer(ServerPlayer player) {
        return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
    }

    public boolean causeFallDamage(float f, float f1, DamageSource damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.causeFallDamage(f, f1, damagesource);
        }
        return false;
    }

    protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.checkFallDamage(d0, flag, iblockdata, blockposition);
        }
    }

    public void die(DamageSource damagesource) {
        if (this.hasGlowingTag) {
            return;
        }
        super.die(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> {
            this.x().removePlayerImmediately((ServerPlayer)this, Entity.RemovalReason.KILLED);
            ((ServerLevel)this.H).k().removeEntity((net.minecraft.world.entity.Entity)this);
        }, 15L);
    }

    public void doTick() {
        boolean navigating;
        if (this.npc == null) {
            super.doTick();
            return;
        }
        super.ao();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.ai.getMoveControl().hasWanted();
        if (!(navigating || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !this.npc.getOrAddTrait(Gravity.class).hasGravity() || !Util.isLoaded(this.getBukkitEntity().getLocation(LOADED_LOCATION)) || this.npc.isProtected() && !SpigotUtil.checkYSafe(this.dn(), this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(Vec3.ZERO);
        }
        Vec3 mot = this.dj();
        if (Math.abs(mot.x) < (double)0.003f && Math.abs(mot.y) < (double)0.003f && Math.abs(mot.z) < (double)0.003f) {
            this.moveTo(Vec3.ZERO);
        }
        if (navigating) {
            if (!this.ai.getNavigation().isDone()) {
                this.ai.getNavigation().tick();
            }
            this.moveOnCurrentHeading();
        }
        this.tickAI();
        this.onUpdateAbilities();
        this.ae = this.F_();
        if (this.F_()) {
            this.N = false;
        }
        this.eZ();
        if (this.npc.useMinecraftAI()) {
            this.bQ.tick((Player)this);
        }
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(false)).booleanValue()) {
            if (this.bU > 0) {
                --this.bU;
            }
            AABB axisalignedbb = this.bL() && !this.cV().dB() ? this.cD().minmax(this.cV().cD()).inflate(1.0, 0.0, 1.0) : this.cD().inflate(1.0, 0.5, 1.0);
            for (net.minecraft.world.entity.Entity entity : this.H.getEntities((net.minecraft.world.entity.Entity)this, axisalignedbb)) {
                entity.playerTouch((Player)this);
            }
        }
        ++this.hurtTime;
        this.ge().tick();
        if (!this.npc.hasTrait(EntityPoseTrait.class) || this.npc.getTraitNullable(EntityPoseTrait.class).getPose() == null) {
            this.fD();
        }
    }

    public PlayerAdvancements M() {
        if (this.npc == null) {
            return super.M();
        }
        if (this.advancements == null) {
            this.advancements = new EmptyAdvancementDataPlayer(this.cH().ay(), this.cH().ac(), this);
        }
        return this.advancements;
    }

    @Override
    public MobAI getAI() {
        return this.ai;
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !this.setBukkitEntity) {
            NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PlayerNPC(this));
            this.setBukkitEntity = true;
        }
        return super.getBukkitEntity();
    }

    protected SoundEvent x_() {
        return NMSImpl.getSoundEffect(this.npc, super.x_(), NPC.Metadata.DEATH_SOUND);
    }

    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return NMSImpl.getSoundEffect(this.npc, super.getHurtSound(damagesource), NPC.Metadata.HURT_SOUND);
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public GameProfile getProfile() {
        return super.fI();
    }

    @Override
    public String getSkinName() {
        String skinName = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public ServerStatsCounter D() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public Component J() {
        if (this.npc != null && this.npc.shouldRemoveFromTabList()) {
            return MutableComponent.create((ComponentContents)new PlainTextContents(""));
        }
        return this.npc != null ? (Component)Messaging.minecraftComponentFromRawMessage(this.npc.getRawName()) : super.J();
    }

    public boolean hurt(DamageSource damagesource, float f) {
        boolean damaged = super.hurt(damagesource, f);
        if (damaged && this.verticalCollisionBelow) {
            this.verticalCollisionBelow = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                this.verticalCollisionBelow = true;
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer) {
        try {
            EmptyNetworkManager conn = new EmptyNetworkManager(PacketFlow.CLIENTBOUND);
            this.b = new EmptyNetHandler(minecraftServer, conn, this);
            conn.setListenerForServerboundHandshake((PacketListener)this.b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ak = 0;
        this.setSkinFlags((byte)-1);
    }

    public boolean canSpawnSprintParticle() {
        if (this.npc == null || this.ae || this.fu()) {
            return super.canSpawnSprintParticle();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean bn() {
        return this.npc == null ? super.bn() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
    }

    public void checkRidingStatistics(double strength, double dx, double dz) {
        NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.checkRidingStatistics((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
    }

    private void moveOnCurrentHeading() {
        if (this.hasVisualFire) {
            if (this.N && this.jumpTicks == 0) {
                this.eS();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.animStepO *= 0.98f;
        this.bl *= 0.98f;
        this.moveWithFallDamage(new Vec3((double)this.animStepO, (double)this.rotOffs, (double)this.bl));
        NMS.setHeadAndBodyYaw((Entity)this.getBukkitEntity(), this.dw());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3 vec) {
        double y = this.dn();
        this.push(vec);
        if (!this.npc.isProtected()) {
            this.a(this.dn() - y, this.N);
        }
    }

    public boolean z_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.z_();
        }
        return false;
    }

    public void push(double x, double y, double z) {
        Vector vector = Util.callPushEvent(this.npc, x, y, z);
        if (vector != null) {
            super.push(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public void g(net.minecraft.world.entity.Entity entity) {
        super.g(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        this.M().save();
    }

    @Override
    public void setSkinFlags(byte flags) {
        this.aj().b(Player.bJ, (Object)flags);
    }

    @Override
    public void setSkinName(String name) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name);
    }

    @Override
    public void setSkinName(String name, boolean forceUpdate) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name, forceUpdate);
    }

    @Override
    public void setSkinPersistent(String skinName, String signature, String data) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(skinName, signature, data);
    }

    public void tick() {
        super.tick();
        if (this.npc == null) {
            return;
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
        if (NMSImpl.PAPER_PLAYER_MOB_COUNTS != null && this.npc.shouldRemoveFromPlayerList()) {
            try {
                int[] counts = NMSImpl.PAPER_PLAYER_MOB_COUNTS.invoke(this);
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = 0;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void tickAI() {
        this.ai.getMoveControl().tick();
        this.ai.getJumpControl().tick();
    }

    public void push(Vec3 vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.push(vec3d);
        } else {
            NMSImpl.flyingMoveLogic((LivingEntity)this, vec3d);
        }
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
        Vec3 old = this.dj().add(0.0, 0.0, 0.0);
        boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
        if (!this.npc.isPushableByFluids()) {
            this.moveTo(old);
        }
        return res;
    }

    private void updatePackets(boolean navigating) {
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.bS = true;
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (ServerPlayer)entity);
            this.npc = entity.npc;
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType().name().contains("ITEM_FRAME")) {
                return false;
            }
            return super.canSee(entity);
        }

        @Override
        public org.bukkit.entity.Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        @Override
        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        @Override
        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        @Override
        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        @Override
        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

