/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftGoat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Goat;
import org.bukkit.util.Vector;

public class GoatController
extends MobEntityController {
    public GoatController() {
        super(EntityGoatNPC.class);
    }

    public Goat getBukkitEntity() {
        return (Goat)super.getBukkitEntity();
    }

    public static class EntityGoatNPC
    extends net.minecraft.world.entity.animal.goat.Goat
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityGoatNPC(EntityType<? extends net.minecraft.world.entity.animal.goat.Goat> types, Level level) {
            this(types, level, null);
        }

        public EntityGoatNPC(EntityType<? extends net.minecraft.world.entity.animal.goat.Goat> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        protected boolean l(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof Boat || entity instanceof AbstractMinecart)) {
                return !this.npc.isProtected();
            }
            return super.l(entity);
        }

        public boolean causeFallDamage(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.causeFallDamage(f, f1, damagesource);
            }
            return false;
        }

        public void ds() {
            if (this.npc == null) {
                super.ds();
            }
        }

        protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.checkFallDamage(d0, flag, iblockdata, blockposition);
            }
        }

        public void updateControlFlags() {
            super.updateControlFlags();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (Mob)this);
                this.npc.update();
            }
        }

        protected SoundEvent s() {
            return NMSImpl.getSoundEffect(this.npc, super.s(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new GoatNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEvent x_() {
            return NMSImpl.getSoundEffect(this.npc, super.x_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEvent getHurtSound(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getHurtSound(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float eQ() {
            return NMS.getJumpPower(this.npc, super.eQ());
        }

        public int cp() {
            return NMS.getFallDistance(this.npc, super.cp());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction C_() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.C_();
        }

        public boolean fI() {
            return NMSImpl.isLeashed(this.npc, () -> super.fI(), (Mob)this);
        }

        public boolean bn() {
            return this.npc == null ? super.bn() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void q(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.q((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AABB am() {
            return NMSBoundingBox.makeBB(this.npc, super.am());
        }

        public boolean z_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.z_();
            }
            return false;
        }

        public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
            if (this.npc == null) {
                super.onSyncedDataUpdated(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((LivingEntity)this, datawatcherobject, x$0 -> super.onSyncedDataUpdated(x$0));
        }

        public void push(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.push(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(ServerLevel worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void push(Vec3 vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.push(vec3d);
            } else {
                NMSImpl.flyingMoveLogic((LivingEntity)this, vec3d);
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.dj().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.moveTo(old);
            }
            return res;
        }
    }

    public static class GoatNPC
    extends CraftGoat
    implements ForwardingNPCHolder {
        public GoatNPC(EntityGoatNPC entity) {
            super((CraftServer)Bukkit.getServer(), (net.minecraft.world.entity.animal.goat.Goat)entity);
        }
    }
}

