/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class BoatController
extends MobEntityController {
    public BoatController() {
        super(EntityBoatNPC.class);
    }

    public org.bukkit.entity.Boat getBukkitEntity() {
        return (org.bukkit.entity.Boat)super.getBukkitEntity();
    }

    public static class EntityBoatNPC
    extends Boat
    implements NPCHolder {
        private double aC;
        private float aD;
        private Boat.Status aE;
        private Boat.Status aF;
        private double ap;
        private final CitizensNPC npc;

        public EntityBoatNPC(EntityType<? extends Boat> types, Level level) {
            this(types, level, null);
        }

        public EntityBoatNPC(EntityType<? extends Boat> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new BoatNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction C_() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.C_();
        }

        private Boat.Status getStatus() {
            Boat.Status entityboat_Status = this.u();
            if (entityboat_Status != null) {
                this.aC = this.cD().maxY;
                return entityboat_Status;
            }
            if (this.t()) {
                return Boat.Status.IN_WATER;
            }
            float f = this.o();
            if (f > 0.0f) {
                this.aD = f;
                return Boat.Status.ON_LAND;
            }
            return Boat.Status.IN_AIR;
        }

        public boolean bn() {
            return this.npc == null ? super.bn() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AABB am() {
            return NMSBoundingBox.makeBB(this.npc, super.am());
        }

        public void push(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.push(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void c_() {
            if (this.npc == null) {
                super.c_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.wasEyeInWater);
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        private boolean t() {
            boolean m = false;
            AABB axisalignedbb = this.cD();
            int i = Mth.floor((double)axisalignedbb.minX);
            int j = Mth.ceil((double)axisalignedbb.maxX);
            int k = Mth.floor((double)axisalignedbb.minY);
            int l = Mth.ceil((double)(axisalignedbb.minY + 0.001));
            int i1 = Mth.floor((double)axisalignedbb.minZ);
            int j1 = Mth.ceil((double)axisalignedbb.maxZ);
            boolean flag = false;
            this.aC = Double.MIN_VALUE;
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.set(k1, l1, i2);
                        FluidState fluid = this.H.getFluidState((BlockPos)blockposition_mutableblockposition);
                        if (!fluid.is(FluidTags.WATER)) continue;
                        float f = (float)l1 + fluid.getHeight((BlockGetter)this.H, (BlockPos)blockposition_mutableblockposition);
                        this.aC = Math.max((double)f, this.aC);
                        m = flag | axisalignedbb.minY < (double)f;
                    }
                }
            }
            return m;
        }

        public net.minecraft.world.entity.Entity teleportTo(ServerLevel worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void tick() {
            if (this.npc != null) {
                this.ao();
                if (this.cK() instanceof NPCHolder && ((NPCHolder)this.cK()).getNPC().getNavigator().isNavigating()) {
                    this.moveTo(this.cK().dj().multiply(20.0, 1.0, 20.0));
                }
                this.npc.update();
                if (this.r() > 0) {
                    this.setHurtTime(this.r() - 1);
                }
                if (this.q() > 0.0f) {
                    this.a(this.q() - 1.0f);
                }
                this.aF = this.aE;
                this.aE = this.getStatus();
                double d1 = this.aP() ? 0.0 : -0.04;
                double d2 = 0.0;
                this.ap = 0.05f;
                if (this.aF == Boat.Status.IN_AIR && this.aE != Boat.Status.IN_AIR && this.aE != Boat.Status.ON_LAND) {
                    this.aC = this.getY(1.0);
                    this.moveTo(this.dl(), (double)(this.k() - this.dd()) + 0.101, this.dr());
                    this.moveTo(this.dj().multiply(1.0, 0.0, 1.0));
                    this.aE = Boat.Status.IN_WATER;
                } else {
                    if (this.aE == Boat.Status.IN_WATER) {
                        d2 = (this.aC - this.dn()) / (double)this.dd();
                        this.ap = 0.9f;
                    } else if (this.aE == Boat.Status.UNDER_FLOWING_WATER) {
                        d1 = -7.0E-4;
                        this.ap = 0.9f;
                    } else if (this.aE == Boat.Status.UNDER_WATER) {
                        d2 = 0.01;
                        this.ap = 0.45f;
                    } else if (this.aE == Boat.Status.IN_AIR) {
                        this.ap = 0.9f;
                    } else if (this.aE == Boat.Status.ON_LAND) {
                        this.ap = this.aD;
                        if (this.cK() instanceof ServerPlayer) {
                            this.aD /= 2.0f;
                        }
                    }
                    Vec3 vec3d = this.dj();
                    this.setPosRaw(vec3d.x * this.ap, vec3d.y + d1, vec3d.z * this.ap);
                    if (d2 > 0.0) {
                        Vec3 vec3d1 = this.dj();
                        this.setPosRaw(vec3d1.x, vec3d1.y + d2 * 0.0615, vec3d1.z);
                    }
                }
                this.move(MoverType.SELF, this.dj());
                this.aL();
            } else {
                super.tick();
            }
        }

        private Boat.Status u() {
            AABB axisalignedbb = this.cD();
            double d0 = axisalignedbb.maxY + 0.001;
            int i = Mth.floor((double)axisalignedbb.minX);
            int j = Mth.ceil((double)axisalignedbb.maxX);
            int k = Mth.floor((double)axisalignedbb.maxY);
            int l = Mth.ceil((double)d0);
            int i1 = Mth.floor((double)axisalignedbb.minZ);
            int j1 = Mth.ceil((double)axisalignedbb.maxZ);
            boolean flag = false;
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.set(k1, l1, i2);
                        FluidState fluid = this.H.getFluidState((BlockPos)blockposition_mutableblockposition);
                        if (!fluid.is(FluidTags.WATER) || !(d0 < (double)((float)blockposition_mutableblockposition.getY() + fluid.getHeight((BlockGetter)this.H, (BlockPos)blockposition_mutableblockposition)))) continue;
                        if (!fluid.isSource()) {
                            return Boat.Status.UNDER_FLOWING_WATER;
                        }
                        flag = true;
                    }
                }
            }
            return flag ? Boat.Status.UNDER_WATER : null;
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.dj().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.moveTo(old);
            }
            return res;
        }
    }

    public static class BoatNPC
    extends CraftBoat
    implements ForwardingNPCHolder {
        public BoatNPC(EntityBoatNPC entity) {
            super((CraftServer)Bukkit.getServer(), (Boat)entity);
        }
    }
}

