/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity.nonliving;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftFishHook;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.util.Vector;

public class FishingHookController
extends MobEntityController {
    public FishingHookController() {
        super(EntityFishingHookNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        ServerLevel level = ((CraftWorld)at.getWorld()).getHandle();
        ServerPlayer sp = new ServerPlayer(level.n(), level, new GameProfile(UUID.randomUUID(), "dummyfishhook")){};
        sp.moveTo(at.getX(), at.getY(), at.getZ());
        sp.playSwimSound(at.getYaw());
        sp.e(at.getPitch());
        sp.heal(20.0f);
        sp.fJ().armor.set(sp.fJ().l, (Object)new ItemStack((ItemLike)Items.SPRUCE_SIGN, 1));
        EntityFishingHookNPC handle = new EntityFishingHookNPC((EntityType<? extends FishingHook>)EntityType.ZOMBIE, (Level)level, npc, sp);
        return handle.getBukkitEntity();
    }

    public FishHook getBukkitEntity() {
        return (FishHook)super.getBukkitEntity();
    }

    public static class EntityFishingHookNPC
    extends FishingHook
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityFishingHookNPC(EntityType<? extends FishingHook> types, Level level) {
            this(types, level, null, null);
        }

        public EntityFishingHookNPC(EntityType<? extends FishingHook> types, Level level, NPC npc, ServerPlayer sp) {
            super((Player)sp, level, 0, 0);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public double f(net.minecraft.world.entity.Entity entity) {
            if (entity == this.j()) {
                return 0.0;
            }
            return super.f(entity);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new FishingHookNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction C_() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.C_();
        }

        public boolean bn() {
            return this.npc == null ? super.bn() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AABB am() {
            return NMSBoundingBox.makeBB(this.npc, super.am());
        }

        public void push(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.push(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(ServerLevel worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void tick() {
            if (this.npc != null) {
                this.j().dD();
                NMSImpl.setLife(this, 0);
                this.npc.update();
            } else {
                super.tick();
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.dj().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.moveTo(old);
            }
            return res;
        }
    }

    public static class FishingHookNPC
    extends CraftFishHook
    implements ForwardingNPCHolder {
        public FishingHookNPC(EntityFishingHookNPC entity) {
            super((CraftServer)Bukkit.getServer(), (FishingHook)entity);
        }
    }
}

