/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftItem;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ItemController
extends AbstractEntityController {
    public ItemController() {
        super(EntityItemNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        EntityItemNPC handle = new EntityItemNPC((Level)((CraftWorld)at.getWorld()).getHandle(), npc, at.getX(), at.getY(), at.getZ(), CraftItemStack.asNMSCopy((ItemStack)npc.getItemProvider().get()));
        return handle.getBukkitEntity();
    }

    public Item getBukkitEntity() {
        return (Item)super.getBukkitEntity();
    }

    public static class EntityItemNPC
    extends ItemEntity
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityItemNPC(EntityType<? extends ItemEntity> types, Level level) {
            super(types, level);
            this.npc = null;
        }

        public EntityItemNPC(Level world, NPC npc, double x, double y, double z, net.minecraft.world.item.ItemStack stack) {
            super(world, x, y, z, stack);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new ItemNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction C_() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.C_();
        }

        public boolean bn() {
            return this.npc == null ? super.bn() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AABB am() {
            return NMSBoundingBox.makeBB(this.npc, super.am());
        }

        public void push(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.push(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(ServerLevel worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.tick();
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.dj().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.moveTo(old);
            }
            return res;
        }
    }

    public static class ItemNPC
    extends CraftItem
    implements NPCHolder {
        private final CitizensNPC npc;

        public ItemNPC(EntityItemNPC entity) {
            super((CraftServer)Bukkit.getServer(), (ItemEntity)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

