/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.collect.ForwardingSet;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.citizensnpcs.api.event.NPCLinkToPlayerEvent;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.NPCUnlinkFromPlayerEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.EntityHumanNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CitizensEntityTracker
extends ChunkMap.TrackedEntity {
    private final Entity tracker;
    private static final MethodHandle E = NMS.getGetter(ServerEntity.class, "e");
    private static final MethodHandle F = NMS.getGetter(ServerEntity.class, "f");
    private static volatile Boolean REQUIRES_SYNC = false;
    private static final MethodHandle TRACKER = NMS.getFirstGetter(ChunkMap.TrackedEntity.class, Entity.class);
    private static final MethodHandle TRACKER_ENTRY = NMS.getFirstGetter(ChunkMap.TrackedEntity.class, ServerEntity.class);
    private static final MethodHandle TRACKING_RANGE = NMS.getFirstGetter(ChunkMap.TrackedEntity.class, Integer.TYPE);
    private static final MethodHandle TRACKING_RANGE_SETTER = NMS.getFirstFinalSetter(ChunkMap.TrackedEntity.class, Integer.TYPE);
    private static final MethodHandle TRACKING_SET_SETTER = NMS.getFirstFinalSetter(ChunkMap.TrackedEntity.class, Set.class);

    public CitizensEntityTracker(ChunkMap map, Entity entity, int i, int j, boolean flag) {
        ChunkMap chunkMap = map;
        Objects.requireNonNull(chunkMap);
        super(chunkMap, entity, i, j, flag);
        this.tracker = entity;
        try {
            final Set set = this.seenBy;
            TRACKING_SET_SETTER.invoke(this, new ForwardingSet<ServerPlayerConnection>(){

                public boolean add(ServerPlayerConnection conn) {
                    boolean res = super.add((Object)conn);
                    if (res) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCLinkToPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)conn.f().getBukkitEntity(), !Bukkit.isPrimaryThread()));
                    }
                    return res;
                }

                protected Set<ServerPlayerConnection> delegate() {
                    return set;
                }

                public boolean remove(Object conn) {
                    boolean removed = super.remove(conn);
                    if (removed) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCUnlinkFromPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)((ServerPlayerConnection)conn).f().getBukkitEntity()));
                    }
                    return removed;
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public CitizensEntityTracker(ChunkMap map, ChunkMap.TrackedEntity entry) {
        this(map, CitizensEntityTracker.getTracker(entry), CitizensEntityTracker.getTrackingDistance(entry), CitizensEntityTracker.getE(entry), CitizensEntityTracker.getF(entry));
    }

    public void updatePlayer(ServerPlayer entityplayer) {
        if (entityplayer instanceof EntityHumanNPC) {
            return;
        }
        if (!this.seenBy.contains(entityplayer.b) && this.tracker instanceof NPCHolder) {
            boolean cancelled;
            NPC npc = ((NPCHolder)this.tracker).getNPC();
            if (REQUIRES_SYNC == null) {
                REQUIRES_SYNC = !Bukkit.isPrimaryThread();
            }
            if (cancelled = Util.callPossiblySync(() -> {
                NPCSeenByPlayerEvent event = new NPCSeenByPlayerEvent(npc, (Player)entityplayer.getBukkitEntity());
                try {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                catch (IllegalStateException e) {
                    REQUIRES_SYNC = true;
                    throw e;
                }
                if (event.isCancelled()) {
                    return true;
                }
                Integer trackingRange = (Integer)npc.data().get(NPC.Metadata.TRACKING_RANGE);
                if (TRACKING_RANGE_SETTER != null && trackingRange != null && npc.data().get("last-tracking-range", Integer.valueOf(-1)).intValue() != trackingRange.intValue()) {
                    try {
                        TRACKING_RANGE_SETTER.invoke(this, trackingRange);
                        npc.data().set("last-tracking-range", (Object)trackingRange);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }, REQUIRES_SYNC).booleanValue()) {
                return;
            }
        }
        super.updatePlayer(entityplayer);
    }

    private static int getE(ChunkMap.TrackedEntity entry) {
        try {
            return E.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static boolean getF(ChunkMap.TrackedEntity entry) {
        try {
            return F.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Collection<Player> getSeenBy(ChunkMap.TrackedEntity tracker) {
        return tracker.seenBy.stream().map(c -> c.f().getBukkitEntity()).collect(Collectors.toSet());
    }

    private static Entity getTracker(ChunkMap.TrackedEntity entry) {
        try {
            return TRACKER.invoke(entry);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getTrackingDistance(ChunkMap.TrackedEntity entry) {
        try {
            return TRACKING_RANGE.invoke(entry);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }
}

