/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import java.util.Random;
import net.citizensnpcs.util.NMS;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.entity.Entity;

public class EntityMoveControl
extends MoveControl {
    protected LivingEntity entity;
    private int jumpTicks;
    protected boolean moving;
    protected double speedMod;
    protected double tx;
    protected double ty;
    protected double tz;

    public EntityMoveControl(LivingEntity entityinsentient) {
        super((Mob)(entityinsentient instanceof Mob ? (Mob)entityinsentient : new Slime(EntityType.SHULKER_BULLET, entityinsentient.H)));
        this.entity = entityinsentient;
        this.tx = entityinsentient.dl();
        this.ty = entityinsentient.dn();
        this.tz = entityinsentient.dr();
    }

    public double getSpeedModifier() {
        return this.speedMod;
    }

    public double getWantedX() {
        return this.tx;
    }

    public double getWantedY() {
        return this.ty;
    }

    public double getWantedZ() {
        return this.tz;
    }

    public boolean hasWanted() {
        return this.moving;
    }

    protected int jumpTicks() {
        return new Random().nextInt(20) + 10;
    }

    protected float rotlerp(float f, float f1, float f2) {
        float f4;
        float f3 = Mth.wrapDegrees((float)(f1 - f));
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        if ((f4 = f + f3) < 0.0f) {
            f4 += 360.0f;
        } else if (f4 > 360.0f) {
            f4 -= 360.0f;
        }
        return f4;
    }

    public void setWantedPosition(double d0, double d1, double d2, double d3) {
        this.tx = d0;
        this.ty = d1;
        this.tz = d2;
        this.speedMod = d3;
        this.moving = true;
    }

    public void tick() {
        this.entity.bl = 0.0f;
        if (!this.moving) {
            return;
        }
        this.moving = false;
        double dX = this.tx - this.entity.dl();
        double dZ = this.tz - this.entity.dr();
        double dY = this.ty - this.entity.dn();
        double dXZ = Math.sqrt(dX * dX + dZ * dZ);
        double dXYZ = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        if (dXYZ < 2.500000277905201E-7) {
            return;
        }
        if (dXZ > 0.4) {
            float f = (float)Math.toDegrees(Mth.atan2((double)dZ, (double)dX)) - 90.0f;
            this.entity.playSwimSound(this.rotlerp(this.entity.dw(), f, 90.0f));
            NMS.setHeadYaw((Entity)this.entity.getBukkitEntity(), this.entity.dw());
        }
        this.entity.bl = (float)(this.speedMod * this.entity.a(Attributes.d).getBaseValue());
        this.entity.h(this.entity.bl);
        if (this.entity instanceof Slime && this.jumpTicks-- <= 0) {
            this.jumpTicks = new Random().nextInt(20) + 10;
            if (((Slime)this.entity).fM()) {
                this.jumpTicks /= 3;
            }
            ((Slime)this.entity).E().jump();
            return;
        }
        BlockPos pos = this.entity.dg();
        BlockState bs = this.entity.H.getBlockState(pos);
        VoxelShape vs = bs.getCollisionShape((BlockGetter)this.entity.H, pos);
        if (dY >= (double)this.entity.dA() && dXZ < (double)Math.max(1.0f, this.entity.dc()) || !vs.b() && this.entity.dn() < vs.max(Direction.Axis.Y) + (double)pos.getY() && !bs.is(BlockTags.STONE_PRESSURE_PLATES) && !bs.is(BlockTags.SMALL_FLOWERS)) {
            NMS.setShouldJump((Entity)this.entity.getBukkitEntity());
        }
    }
}

