/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_19_R3.util.EntityNodeEvaluator;
import net.citizensnpcs.nms.v1_19_R3.util.EntityPathfinder;
import net.citizensnpcs.nms.v1_19_R3.util.MobAI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class EntityNavigation
extends PathNavigation {
    private boolean avoidSun;
    private final AttributeInstance followRange;
    protected boolean m;
    private boolean isStuck;
    protected int f;
    protected Vec3 g = Vec3.ZERO;
    protected long j;
    protected float l = 0.5f;
    private float maxVisitedNodesMultiplier = 1.0f;
    private final LivingEntity mob;
    private final MobAI mvmt;
    protected EntityNodeEvaluator nodeEvaluator;
    protected Path c;
    private final EntityPathfinder pathFinder;
    private int reachRange;
    protected double d;
    private BlockPos targetPos;
    protected int e;
    protected long n;
    protected Vec3i h = Vec3i.ZERO;
    protected double k;
    protected long i;

    public EntityNavigation(LivingEntity entityinsentient, Level world) {
        super((Mob)new Slime(EntityType.SHULKER_BULLET, world), world);
        this.mob = entityinsentient;
        this.mvmt = MobAI.from((Entity)entityinsentient);
        this.followRange = entityinsentient.a(Attributes.b);
        this.nodeEvaluator = new EntityNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        this.pathFinder = new EntityPathfinder(this.nodeEvaluator, Settings.Setting.MAXIMUM_VISITED_NODES.asInt());
        this.setRange(24.0f);
    }

    public boolean canCutCorner(PathType var0) {
        return var0 != PathType.DANGER_FIRE && var0 != PathType.DANGER_OTHER && var0 != PathType.WALKABLE_DOOR;
    }

    public boolean q() {
        return this.nodeEvaluator.canFloat();
    }

    protected boolean canMoveDirectly(Vec3 var0, Vec3 var1) {
        return false;
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.canPassDoors();
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.canPassDoors();
    }

    protected boolean canUpdatePath() {
        return this.mob.ax() || this.o() || this.mob.bL();
    }

    public Path createPath(BlockPos var0, int var1) {
        BlockPos var2;
        if (this.level.getBlockState(var0).h()) {
            var2 = var0.above();
            while (var2.getY() > this.level.v_() && this.level.getBlockState(var2).h()) {
                var2 = var2.above();
            }
            if (var2.getY() > this.level.v_()) {
                return this.supercreatePath(var2.c(), var1);
            }
            while (var2.getY() < this.level.ai() && this.level.getBlockState(var2).h()) {
                var2 = var2.c();
            }
            var0 = var2;
        }
        if (!this.level.getBlockState(var0).d().b()) {
            return this.supercreatePath(var0, var1);
        }
        var2 = var0.c();
        while (var2.getY() < this.level.ai() && this.level.getBlockState(var2).d().b()) {
            var2 = var2.c();
        }
        return this.supercreatePath(var2, var1);
    }

    public Path createPath(BlockPos var0, int var1, int var2) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)var0), 8, false, var1, var2);
    }

    public Path createPath(Entity var0, int var1) {
        return this.createPath(var0.dg(), var1);
    }

    public Path createPath(Set<BlockPos> var0, int var1) {
        return this.createPath(var0, 8, false, var1);
    }

    protected Path createPath(Set<BlockPos> var0, int var1, boolean var2, int var3) {
        return this.createPath(var0, var1, var2, var3, (float)this.followRange.getValue());
    }

    protected Path createPath(Set<BlockPos> var0, int var1, boolean var2, int var3, float var4) {
        if (var0.isEmpty()) {
            return null;
        }
        if (this.mob.dn() < (double)this.level.v_()) {
            return null;
        }
        if (!this.canUpdatePath()) {
            return null;
        }
        if (this.c != null && !this.c.isDone() && var0.contains(this.targetPos)) {
            return this.c;
        }
        this.level.ac().push("pathfind");
        BlockPos var5 = var2 ? this.mob.dg().c() : this.mob.dg();
        int var6 = (int)(var4 + (float)var1);
        PathNavigationRegion var7 = new PathNavigationRegion(this.level, var5.offset(-var6, -var6, -var6), var5.offset(var6, var6, var6));
        Path var8 = this.pathFinder.findPath(var7, this.mob, var0, var4, var3, this.maxVisitedNodesMultiplier);
        this.level.ac().pop();
        if (var8 != null && var8.m() != null) {
            this.targetPos = var8.m();
            this.reachRange = var3;
            this.resetStuckTimeout();
        }
        return var8;
    }

    public Path createPath(Stream<BlockPos> var0, int var1) {
        return this.createPath(var0.collect(Collectors.toSet()), 8, false, var1);
    }

    protected PathFinder createPathFinder(int paramInt) {
        return null;
    }

    protected void doStuckDetection(Vec3 var0) {
        if (this.e - this.f > 100) {
            float var1 = this.mob.eW() >= 1.0f ? this.mob.eW() : this.mob.eW() * this.mob.eW();
            float var2 = var1 * 100.0f * 0.25f;
            if (var0.distanceToSqr(this.g) < (double)(var2 * var2)) {
                this.isStuck = true;
                this.stop();
            } else {
                this.isStuck = false;
            }
            this.f = this.e;
            this.g = var0;
        }
        if (this.c != null && !this.c.isDone()) {
            BlockPos var1 = this.c.getNextNodePos();
            long var2 = this.level.U();
            if (var1.equals((Object)this.h)) {
                this.i += var2 - this.j;
            } else {
                this.h = var1;
                double var4 = var0.distanceTo(Vec3.atBottomCenterOf((Vec3i)this.h));
                double d = this.k = this.mob.eW() > 0.0f ? var4 / (double)this.mob.eW() * 20.0 : 0.0;
            }
            if (this.k > 0.0 && (double)this.i > this.k * 3.0) {
                this.timeoutPath();
            }
            this.j = var2;
        }
    }

    protected void followThePath() {
        boolean var8;
        Vec3 var0 = this.getTempMobPos();
        this.l = this.mob.dc() > 0.75f ? this.mob.dc() / 2.0f : 0.75f - this.mob.dc() / 2.0f;
        BlockPos var1 = this.c.getNextNodePos();
        double var2 = Math.abs(this.mob.dl() - ((double)var1.getX() + 0.5));
        double var4 = Math.abs(this.mob.dn() - (double)var1.getY());
        double var6 = Math.abs(this.mob.dr() - ((double)var1.getZ() + 0.5));
        boolean bl = var8 = var2 < (double)this.l && var6 < (double)this.l && var4 < 1.0;
        if (var8 || this.canCutCorner(this.c.getNextNode().type) && this.shouldTargetNextNodeInDirection(var0)) {
            this.c.advance();
        }
        this.doStuckDetection(var0);
    }

    protected double getGroundY(Vec3 var0) {
        BlockPos var1 = BlockPos.containing((Position)var0);
        return this.level.getBlockState(var1.above()).h() ? var0.y : EntityNodeEvaluator.getFloorLevel((BlockGetter)this.level, var1);
    }

    public float r() {
        return this.l;
    }

    public NodeEvaluator p() {
        return this.nodeEvaluator;
    }

    public Path getPath() {
        return this.c;
    }

    public Path getPathEntity() {
        return this.c;
    }

    private int getSurfaceY() {
        if (this.mob.aT() && this.q()) {
            int var0 = this.mob.dm();
            BlockState var1 = this.level.getBlockState(BlockPos.containing((double)this.mob.dl(), (double)var0, (double)this.mob.dr()));
            int var2 = 0;
            do {
                if (!var1.is(Blocks.WATER)) {
                    return var0;
                }
                var1 = this.level.getBlockState(BlockPos.containing((double)this.mob.dl(), (double)(++var0), (double)this.mob.dr()));
            } while (++var2 <= 16);
            return this.mob.dm();
        }
        return Mth.floor((double)(this.mob.dn() + 0.5));
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.dl(), (double)this.getSurfaceY(), this.mob.dr());
    }

    protected boolean hasValidPathType(PathType var0) {
        if (var0 == PathType.WATER) {
            return false;
        }
        if (var0 == PathType.LAVA) {
            return false;
        }
        return var0 != PathType.OPEN;
    }

    public boolean isDone() {
        return this.c == null || this.c.isDone();
    }

    protected boolean o() {
        return this.mob.isFlapping() || this.mob.isInWaterOrRain();
    }

    public boolean isInProgress() {
        return !this.isDone();
    }

    public boolean isStableDestination(BlockPos var0) {
        BlockPos var1 = var0.above();
        return this.level.getBlockState(var1).isSolidRender((BlockGetter)this.level, var1);
    }

    public boolean s() {
        return this.isStuck;
    }

    public boolean moveTo(double var0, double var2, double var4, double var6) {
        return this.moveTo(this.createPath(BlockPos.containing((double)var0, (double)var2, (double)var4), 1), var6);
    }

    public boolean moveTo(Entity var0, double var1) {
        Path var3 = this.createPath(var0, 1);
        return var3 != null && this.moveTo(var3, var1);
    }

    public boolean moveTo(Path var0, double var1) {
        if (var0 == null) {
            this.c = null;
            return false;
        }
        if (!var0.sameAs(this.c)) {
            this.c = var0;
        }
        if (this.isDone()) {
            return false;
        }
        this.K_();
        if (this.c.getNodeCount() <= 0) {
            return false;
        }
        this.d = var1;
        Vec3 var3 = this.getTempMobPos();
        this.f = this.e;
        this.g = var3;
        return true;
    }

    public void recomputePath() {
        if (this.level.U() - this.n > 20L) {
            if (this.targetPos != null) {
                this.c = null;
                this.c = this.createPath(this.targetPos, this.reachRange);
                this.n = this.level.U();
                this.m = false;
            }
        } else {
            this.m = true;
        }
    }

    public void resetMaxVisitedNodesMultiplier() {
        this.maxVisitedNodesMultiplier = 1.0f;
    }

    private void resetStuckTimeout() {
        this.h = Vec3i.ZERO;
        this.i = 0L;
        this.k = 0.0;
        this.isStuck = false;
    }

    public void setAvoidSun(boolean var0) {
        this.avoidSun = var0;
    }

    public void setCanFloat(boolean var0) {
        this.nodeEvaluator.setCanFloat(var0);
    }

    public void setCanOpenDoors(boolean var0) {
        this.nodeEvaluator.setCanOpenDoors(var0);
    }

    public void setCanPassDoors(boolean var0) {
        this.nodeEvaluator.setCanPassDoors(var0);
    }

    public void setMaxVisitedNodesMultiplier(float var0) {
        this.maxVisitedNodesMultiplier = var0;
    }

    public void setRange(float pathfindingRange) {
        this.followRange.setBaseValue((double)pathfindingRange);
    }

    public void setSpeedModifier(double var0) {
        this.d = var0;
    }

    public boolean shouldRecomputePath(BlockPos var0) {
        if (this.m) {
            return false;
        }
        if (this.c != null && !this.c.isDone() && this.c.getNodeCount() != 0) {
            Node var1 = this.c.getEndNode();
            Vec3 var2 = new Vec3(((double)var1.x + this.mob.dl()) / 2.0, ((double)var1.y + this.mob.dn()) / 2.0, ((double)var1.z + this.mob.dr()) / 2.0);
            return var0.closerToCenterThan((Position)var2, (double)(this.c.getNodeCount() - this.c.getNextNodeIndex()));
        }
        return false;
    }

    private boolean shouldTargetNextNodeInDirection(Vec3 var0) {
        Vec3 var4;
        if (this.c.getNextNodeIndex() + 1 >= this.c.getNodeCount()) {
            return false;
        }
        Vec3 var1 = Vec3.atBottomCenterOf((Vec3i)this.c.getNextNodePos());
        if (!var0.closerThan((Position)var1, 2.0)) {
            return false;
        }
        Vec3 var2 = Vec3.atBottomCenterOf((Vec3i)this.c.getNodePos(this.c.getNextNodeIndex() + 1));
        Vec3 var3 = var2.subtract(var1);
        return var3.dot(var4 = var0.subtract(var1)) > 0.0;
    }

    public void stop() {
        this.c = null;
    }

    public Path supercreatePath(BlockPos var0, int var1) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)var0), 8, false, var1);
    }

    protected void supertrimPath() {
        if (this.c == null) {
            return;
        }
        for (int var0 = 0; var0 < this.c.getNodeCount(); ++var0) {
            Node var1 = this.c.getNode(var0);
            Node var2 = var0 + 1 < this.c.getNodeCount() ? this.c.getNode(var0 + 1) : null;
            BlockState var3 = this.level.getBlockState(new BlockPos(var1.x, var1.y, var1.z));
            if (!var3.is(BlockTags.BASE_STONE_NETHER)) continue;
            this.c.replaceNode(var0, var1.cloneAndMove(var1.x, var1.y + 1, var1.z));
            if (var2 == null || var1.y < var2.y) continue;
            this.c.replaceNode(var0 + 1, var1.cloneAndMove(var2.x, var1.y + 1, var2.z));
        }
    }

    public void tick() {
        ++this.e;
        if (this.m) {
            this.recomputePath();
        }
        if (this.isDone()) {
            return;
        }
        if (this.canUpdatePath()) {
            this.followThePath();
        } else if (this.c != null && !this.c.isDone()) {
            Vec3 vec31 = this.getTempMobPos();
            Vec3 vec32 = this.c.getNextEntityPos((Entity)this.mob);
            if (vec31.y > vec32.y && !this.mob.ax() && Mth.floor((double)vec31.x) == Mth.floor((double)vec32.x) && Mth.floor((double)vec31.z) == Mth.floor((double)vec32.z)) {
                this.c.advance();
            }
        }
        if (this.isDone()) {
            return;
        }
        Vec3 var0 = this.c.getNextEntityPos((Entity)this.mob);
        this.mvmt.getMoveControl().setWantedPosition(var0.x, this.getGroundY(var0), var0.z, this.d);
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.stop();
    }

    protected void K_() {
        this.supertrimPath();
        if (this.avoidSun) {
            if (this.level.isInWorldBoundsHorizontal(BlockPos.containing((double)this.mob.dl(), (double)(this.mob.dn() + 0.5), (double)this.mob.dr()))) {
                return;
            }
            for (int var0 = 0; var0 < this.c.getNodeCount(); ++var0) {
                Node var1 = this.c.getNode(var0);
                if (!this.level.isInWorldBoundsHorizontal(new BlockPos(var1.x, var1.y, var1.z))) continue;
                this.c.truncateNodes(var0);
                return;
            }
        }
    }
}

