/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import net.citizensnpcs.nms.v1_19_R3.util.EntityNodeEvaluatorBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityNodeEvaluator
extends EntityNodeEvaluatorBase {
    private final Object2BooleanMap collisionCache = new Object2BooleanOpenHashMap();
    protected float oldWaterCost;
    private final Long2ObjectMap pathTypesByPosCache = new Long2ObjectOpenHashMap();
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;

    private boolean canReachWithoutCollision(Node var0) {
        AABB var1 = this.mob.cD();
        Vec3 var2 = new Vec3((double)var0.x - this.mob.dl() + var1.getXsize() / 2.0, (double)var0.y - this.mob.dn() + var1.getYsize() / 2.0, (double)var0.z - this.mob.dr() + var1.getZsize() / 2.0);
        int var3 = Mth.ceil((double)(var2.length() / var1.getSize()));
        var2 = var2.scale((double)(1.0f / (float)var3));
        for (int var4 = 1; var4 <= var3; ++var4) {
            if (!this.hasCollisions(var1 = var1.move(var2))) continue;
            return false;
        }
        return true;
    }

    protected boolean canStartAt(BlockPos var0) {
        PathType var1 = this.getBlockPathType(this.mob, var0);
        return var1 != PathType.OPEN && this.mvmt.getPathfindingMalus(var1) >= 0.0f;
    }

    @Override
    public void done() {
        this.mvmt.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        this.pathTypesByPosCache.clear();
        this.collisionCache.clear();
        super.done();
    }

    protected PathType evaluateBlockPathType(BlockGetter var0, BlockPos var1, PathType var2) {
        boolean var3 = this.canPassDoors();
        if (var2 == PathType.DOOR_WOOD_CLOSED && this.canOpenDoors() && var3) {
            var2 = PathType.WALKABLE_DOOR;
        }
        if (var2 == PathType.DOOR_OPEN && !var3) {
            var2 = PathType.BLOCKED;
        }
        if (var2 == PathType.RAIL && !(var0.getBlockState(var1).getBlock() instanceof BaseRailBlock) && !(var0.getBlockState(var1.above()).getBlock() instanceof BaseRailBlock)) {
            var2 = PathType.UNPASSABLE_RAIL;
        }
        return var2;
    }

    protected Node findAcceptedNode(int var0, int var1, int var2, int var3, double var4, Direction var6, PathType var7) {
        double var18;
        double var16;
        AABB var20;
        Node var8 = null;
        BlockPos.MutableBlockPos var9 = new BlockPos.MutableBlockPos();
        double var10 = this.getFloorLevel((BlockPos)var9.set(var0, var1, var2));
        if (var10 - var4 > this.getMobJumpHeight()) {
            return null;
        }
        PathType var12 = this.getCachedBlockType(this.mob, var0, var1, var2);
        float var13 = this.mvmt.getPathfindingMalus(var12);
        double var14 = (double)this.mob.dc() / 2.0;
        if (var13 >= 0.0f) {
            var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, var13);
        }
        if (EntityNodeEvaluator.doesBlockHavePartialCollision(var7) && var8 != null && var8.costMalus >= 0.0f && !this.canReachWithoutCollision(var8)) {
            var8 = null;
        }
        if (var12 == PathType.WALKABLE || this.isAmphibious() && var12 == PathType.WATER) {
            return var8;
        }
        if ((var8 == null || var8.costMalus < 0.0f) && var3 > 0 && (var12 != PathType.FENCE || this.canWalkOverFences()) && var12 != PathType.UNPASSABLE_RAIL && var12 != PathType.TRAPDOOR && var12 != PathType.POWDER_SNOW && (var8 = this.findAcceptedNode(var0, var1 + 1, var2, var3 - 1, var4, var6, var7)) != null && (var8.type == PathType.OPEN || var8.type == PathType.WALKABLE) && this.mob.dc() < 1.0f && this.hasCollisions(var20 = new AABB((var16 = (double)(var0 - var6.getStepX()) + 0.5) - var14, this.getFloorLevel((BlockPos)var9.set(var16, (double)(var1 + 1), var18 = (double)(var2 - var6.getStepZ()) + 0.5)) + 0.001, var18 - var14, var16 + var14, (double)this.mob.dd() + this.getFloorLevel((BlockPos)var9.set((double)var8.x, (double)var8.y, (double)var8.z)) - 0.002, var18 + var14))) {
            var8 = null;
        }
        if (!this.isAmphibious() && var12 == PathType.WATER && !this.canFloat()) {
            if (this.getCachedBlockType(this.mob, var0, var1 - 1, var2) != PathType.WATER) {
                return var8;
            }
            while (var1 > this.mob.H.v_()) {
                if ((var12 = this.getCachedBlockType(this.mob, var0, --var1, var2)) != PathType.WATER) {
                    return var8;
                }
                var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, this.mvmt.getPathfindingMalus(var12));
            }
        }
        if (var12 == PathType.OPEN) {
            int var162 = 0;
            int var17 = var1;
            while (var12 == PathType.OPEN) {
                if (--var1 < this.mob.H.v_()) {
                    return this.getBlockedNode(var0, var17, var2);
                }
                if (var162++ >= this.mob.cp()) {
                    return this.getBlockedNode(var0, var1, var2);
                }
                var12 = this.getCachedBlockType(this.mob, var0, var1, var2);
                var13 = this.mvmt.getPathfindingMalus(var12);
                if (var12 != PathType.OPEN && var13 >= 0.0f) {
                    var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, var13);
                    break;
                }
                if (!(var13 < 0.0f)) continue;
                return this.getBlockedNode(var0, var1, var2);
            }
        }
        if (EntityNodeEvaluator.doesBlockHavePartialCollision(var12) && var8 == null) {
            var8 = this.b(var0, var1, var2);
            var8.closed = true;
            var8.type = var12;
            var8.costMalus = var12.getMalus();
        }
        return var8;
    }

    private Node getBlockedNode(int var0, int var1, int var2) {
        Node var3 = this.b(var0, var1, var2);
        var3.type = PathType.BLOCKED;
        var3.costMalus = -1.0f;
        return var3;
    }

    public PathType a(BlockGetter var0, int var1, int var2, int var3) {
        return EntityNodeEvaluator.getBlockPathTypeStatic(var0, new BlockPos.MutableBlockPos(var1, var2, var3));
    }

    public PathType getBlockPathType(BlockGetter var0, int var1, int var2, int var3, LivingEntity var4) {
        EnumSet<PathType> var5 = EnumSet.noneOf(PathType.class);
        PathType var6 = PathType.BLOCKED;
        var6 = this.getBlockPathTypes(var0, var1, var2, var3, var5, var6, var4.dg());
        if (var5.contains(PathType.FENCE)) {
            return PathType.FENCE;
        }
        if (var5.contains(PathType.UNPASSABLE_RAIL)) {
            return PathType.UNPASSABLE_RAIL;
        }
        PathType var7 = PathType.BLOCKED;
        for (PathType varr9 : var5) {
            if (this.mvmt.getPathfindingMalus(varr9) < 0.0f) {
                return varr9;
            }
            if (!(this.mvmt.getPathfindingMalus(varr9) >= this.mvmt.getPathfindingMalus(var7))) continue;
            var7 = varr9;
        }
        if (var6 == PathType.OPEN && this.mvmt.getPathfindingMalus(var7) == 0.0f && this.d <= 1) {
            return PathType.OPEN;
        }
        return var7;
    }

    public PathType a(BlockGetter var0, int var1, int var2, int var3, Mob var4) {
        EnumSet<PathType> var5 = EnumSet.noneOf(PathType.class);
        PathType var6 = PathType.BLOCKED;
        var6 = this.getBlockPathTypes(var0, var1, var2, var3, var5, var6, var4.dg());
        if (var5.contains(PathType.FENCE)) {
            return PathType.FENCE;
        }
        if (var5.contains(PathType.UNPASSABLE_RAIL)) {
            return PathType.UNPASSABLE_RAIL;
        }
        PathType var7 = PathType.BLOCKED;
        for (PathType varr9 : var5) {
            if (this.mvmt.getPathfindingMalus(varr9) < 0.0f) {
                return varr9;
            }
            if (!(this.mvmt.getPathfindingMalus(varr9) >= this.mvmt.getPathfindingMalus(var7))) continue;
            var7 = varr9;
        }
        if (var6 == PathType.OPEN && this.mvmt.getPathfindingMalus(var7) == 0.0f && this.d <= 1) {
            return PathType.OPEN;
        }
        return var7;
    }

    protected PathType getBlockPathType(LivingEntity var0, BlockPos var1) {
        return this.getCachedBlockType(var0, var1.getX(), var1.getY(), var1.getZ());
    }

    public PathType getBlockPathTypes(BlockGetter var0, int var1, int var2, int var3, EnumSet var4, PathType var5, BlockPos var6) {
        for (int var7 = 0; var7 < this.d; ++var7) {
            for (int var8 = 0; var8 < this.e; ++var8) {
                for (int var9 = 0; var9 < this.f; ++var9) {
                    int var10 = var7 + var1;
                    int var11 = var8 + var2;
                    int var12 = var9 + var3;
                    PathType var13 = this.a(var0, var10, var11, var12);
                    var13 = this.evaluateBlockPathType(var0, var6, var13);
                    if (var7 == 0 && var8 == 0 && var9 == 0) {
                        var5 = var13;
                    }
                    var4.add(var13);
                }
            }
        }
        return var5;
    }

    protected PathType getCachedBlockType(LivingEntity var0, int var1, int var2, int var3) {
        return (PathType)this.pathTypesByPosCache.computeIfAbsent(BlockPos.asLong((int)var1, (int)var2, (int)var3), var4 -> this.getBlockPathType((BlockGetter)this.a, var1, var2, var3, var0));
    }

    protected double getFloorLevel(BlockPos var0) {
        return (this.canFloat() || this.isAmphibious()) && this.a.getFluidState(var0).is(FluidTags.WATER) ? (double)var0.getY() + 0.5 : EntityNodeEvaluator.getFloorLevel((BlockGetter)this.a, var0);
    }

    public Target getTarget(double var0, double var2, double var4) {
        return this.a(this.b(Mth.floor((double)var0), Mth.floor((double)var2), Mth.floor((double)var4)));
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.dA());
    }

    public int getNeighbors(Node[] var0, Node var1) {
        Node var15;
        Node var14;
        Node var13;
        Node var12;
        Node var11;
        Node var10;
        Node var9;
        double var6;
        Node var8;
        int var2 = 0;
        int var3 = 0;
        PathType var4 = this.getCachedBlockType(this.mob, var1.x, var1.y + 1, var1.z);
        PathType var5 = this.getCachedBlockType(this.mob, var1.x, var1.y, var1.z);
        if (this.mvmt.getPathfindingMalus(var4) >= 0.0f && var5 != PathType.STICKY_HONEY) {
            var3 = Mth.floor((float)Math.max(1.0f, this.mob.dA()));
        }
        if (this.isNeighborValid(var8 = this.findAcceptedNode(var1.x, var1.y, var1.z + 1, var3, var6 = this.getFloorLevel(new BlockPos(var1.x, var1.y, var1.z)), Direction.SOUTH, var5), var1)) {
            var0[var2++] = var8;
        }
        if (this.isNeighborValid(var9 = this.findAcceptedNode(var1.x - 1, var1.y, var1.z, var3, var6, Direction.WEST, var5), var1)) {
            var0[var2++] = var9;
        }
        if (this.isNeighborValid(var10 = this.findAcceptedNode(var1.x + 1, var1.y, var1.z, var3, var6, Direction.EAST, var5), var1)) {
            var0[var2++] = var10;
        }
        if (this.isNeighborValid(var11 = this.findAcceptedNode(var1.x, var1.y, var1.z - 1, var3, var6, Direction.NORTH, var5), var1)) {
            var0[var2++] = var11;
        }
        if (this.isDiagonalValid(var1, var9, var11, var12 = this.findAcceptedNode(var1.x - 1, var1.y, var1.z - 1, var3, var6, Direction.NORTH, var5))) {
            var0[var2++] = var12;
        }
        if (this.isDiagonalValid(var1, var10, var11, var13 = this.findAcceptedNode(var1.x + 1, var1.y, var1.z - 1, var3, var6, Direction.NORTH, var5))) {
            var0[var2++] = var13;
        }
        if (this.isDiagonalValid(var1, var9, var8, var14 = this.findAcceptedNode(var1.x - 1, var1.y, var1.z + 1, var3, var6, Direction.SOUTH, var5))) {
            var0[var2++] = var14;
        }
        if (this.isDiagonalValid(var1, var10, var8, var15 = this.findAcceptedNode(var1.x + 1, var1.y, var1.z + 1, var3, var6, Direction.SOUTH, var5))) {
            var0[var2++] = var15;
        }
        return var2;
    }

    private Node getNodeAndUpdateCostToMax(int var0, int var1, int var2, PathType var3, float var4) {
        Node var5 = this.b(var0, var1, var2);
        var5.type = var3;
        var5.costMalus = Math.max(var5.costMalus, var4);
        return var5;
    }

    public Node getStart() {
        BlockPos var3;
        int var0;
        BlockPos.MutableBlockPos var1;
        block12: {
            var1 = new BlockPos.MutableBlockPos();
            var0 = this.mob.dm();
            BlockState var2 = this.a.getBlockState((BlockPos)var1.set(this.mob.dl(), (double)var0, this.mob.dr()));
            if (!this.mob.canStandOnFluid(var2.r())) {
                if (this.canFloat() && this.mob.aT()) {
                    while (true) {
                        if (!var2.is(Blocks.WATER) && var2.r() != Fluids.WATER.getSource(false)) {
                            --var0;
                            break block12;
                        }
                        var2 = this.a.getBlockState((BlockPos)var1.set(this.mob.dl(), (double)(++var0), this.mob.dr()));
                    }
                }
                if (this.mob.ax()) {
                    var0 = Mth.floor((double)(this.mob.dn() + 0.5));
                } else {
                    var3 = this.mob.dg();
                    while ((this.a.getBlockState(var3).h() || this.a.getBlockState(var3).a((BlockGetter)this.a, var3, PathComputationType.LAND)) && var3.getY() > this.mob.H.v_()) {
                        var3 = var3.above();
                    }
                    var0 = var3.c().getY();
                }
            } else {
                while (true) {
                    if (!this.mob.canStandOnFluid(var2.r())) {
                        --var0;
                        break;
                    }
                    var2 = this.a.getBlockState((BlockPos)var1.set(this.mob.dl(), (double)(++var0), this.mob.dr()));
                }
            }
        }
        var3 = this.mob.dg();
        if (!this.canStartAt((BlockPos)var1.set(var3.getX(), var0, var3.getZ()))) {
            AABB var4 = this.mob.cD();
            if (this.canStartAt((BlockPos)var1.set(var4.minX, (double)var0, var4.minZ)) || this.canStartAt((BlockPos)var1.set(var4.minX, (double)var0, var4.maxZ)) || this.canStartAt((BlockPos)var1.set(var4.maxX, (double)var0, var4.minZ)) || this.canStartAt((BlockPos)var1.set(var4.maxX, (double)var0, var4.maxZ))) {
                return this.getStartNode((BlockPos)var1);
            }
        }
        return this.getStartNode(new BlockPos(var3.getX(), var0, var3.getZ()));
    }

    protected Node getStartNode(BlockPos var0) {
        Node var1 = this.getNode(var0);
        var1.type = this.getBlockPathType(this.mob, var1.asBlockPos());
        var1.costMalus = this.mvmt.getPathfindingMalus(var1.type);
        return var1;
    }

    private boolean hasCollisions(AABB var0) {
        return this.collisionCache.computeIfAbsent((Object)var0, var1 -> !this.a.noCollision((Entity)this.mob, var0));
    }

    protected boolean isAmphibious() {
        return false;
    }

    protected boolean isDiagonalValid(Node var0, Node var1, Node var2, Node var3) {
        if (var3 != null && var2 != null && var1 != null) {
            if (var3.closed) {
                return false;
            }
            if (var2.y <= var0.y && var1.y <= var0.y) {
                if (var1.type != PathType.WALKABLE_DOOR && var2.type != PathType.WALKABLE_DOOR && var3.type != PathType.WALKABLE_DOOR) {
                    boolean var4 = var2.type == PathType.FENCE && var1.type == PathType.FENCE && (double)this.mob.dc() < 0.5;
                    return var3.costMalus >= 0.0f && (var2.y < var0.y || var2.costMalus >= 0.0f || var4) && (var1.y < var0.y || var1.costMalus >= 0.0f || var4);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    protected boolean isNeighborValid(Node var0, Node var1) {
        return var0 != null && !var0.closed && (var0.costMalus >= 0.0f || var1.costMalus < 0.0f);
    }

    @Override
    public void prepare(PathNavigationRegion var0, LivingEntity var1) {
        super.prepare(var0, var1);
        this.oldWaterCost = this.mvmt.getPathfindingMalus(PathType.WATER);
    }

    @Override
    public void prepare(PathNavigationRegion var0, Mob var1) {
        super.prepare(var0, var1);
        this.oldWaterCost = var1.getPathfindingMalus(PathType.WATER);
    }

    public static PathType checkNeighbourBlocks(BlockGetter var0, BlockPos.MutableBlockPos var1, PathType var2) {
        int var3 = var1.getX();
        int var4 = var1.getY();
        int var5 = var1.getZ();
        for (int var6 = -1; var6 <= 1; ++var6) {
            for (int var7 = -1; var7 <= 1; ++var7) {
                for (int var8 = -1; var8 <= 1; ++var8) {
                    if (var6 == 0 && var8 == 0) continue;
                    var1.set(var3 + var6, var4 + var7, var5 + var8);
                    BlockState var9 = var0.getBlockState((BlockPos)var1);
                    if (var9.is(Blocks.SNOW_BLOCK) || var9.is(Blocks.LANTERN)) {
                        return PathType.DANGER_OTHER;
                    }
                    if (EntityNodeEvaluator.isBurningBlock(var9)) {
                        return PathType.DANGER_FIRE;
                    }
                    if (!var0.getFluidState((BlockPos)var1).is(FluidTags.WATER)) continue;
                    return PathType.WATER_BORDER;
                }
            }
        }
        return var2;
    }

    private static boolean doesBlockHavePartialCollision(PathType var0) {
        return var0 == PathType.FENCE || var0 == PathType.DOOR_WOOD_CLOSED || var0 == PathType.DOOR_IRON_CLOSED;
    }

    protected static PathType getBlockPathTypeRaw(BlockGetter var0, BlockPos var1) {
        BlockState var2 = var0.getBlockState(var1);
        Block var3 = var2.getBlock();
        Material var4 = var2.d();
        if (var2.h()) {
            return PathType.OPEN;
        }
        if (!(var2.is(BlockTags.RAILS) || var2.is(Blocks.MYCELIUM) || var2.is(Blocks.WAXED_WEATHERED_COPPER))) {
            if (var2.is(Blocks.SMALL_AMETHYST_BUD)) {
                return PathType.POWDER_SNOW;
            }
            if (!var2.is(Blocks.SNOW_BLOCK) && !var2.is(Blocks.LANTERN)) {
                if (var2.is(Blocks.COMPOSTER)) {
                    return PathType.STICKY_HONEY;
                }
                if (var2.is(Blocks.REDSTONE_LAMP)) {
                    return PathType.COCOA;
                }
                FluidState var5 = var0.getFluidState(var1);
                if (var5.is(FluidTags.LAVA)) {
                    return PathType.LAVA;
                }
                if (EntityNodeEvaluator.isBurningBlock(var2)) {
                    return PathType.DAMAGE_FIRE;
                }
                if (DoorBlock.isWoodenDoor((BlockState)var2) && !((Boolean)var2.getValue((Property)DoorBlock.b)).booleanValue()) {
                    return PathType.DOOR_WOOD_CLOSED;
                }
                if (var3 instanceof DoorBlock && var4 == Material.K && !((Boolean)var2.getValue((Property)DoorBlock.b)).booleanValue()) {
                    return PathType.DOOR_IRON_CLOSED;
                }
                if (var3 instanceof DoorBlock && ((Boolean)var2.getValue((Property)DoorBlock.b)).booleanValue()) {
                    return PathType.DOOR_OPEN;
                }
                if (var3 instanceof BaseRailBlock) {
                    return PathType.RAIL;
                }
                if (var3 instanceof LeavesBlock) {
                    return PathType.LEAVES;
                }
                if (var2.is(BlockTags.SMALL_FLOWERS) || var2.is(BlockTags.STAIRS) || var3 instanceof FenceGateBlock && !((Boolean)var2.getValue((Property)FenceGateBlock.a)).booleanValue()) {
                    return PathType.FENCE;
                }
                if (!var2.a(var0, var1, PathComputationType.LAND)) {
                    return PathType.BLOCKED;
                }
                return var5.is(FluidTags.WATER) ? PathType.WATER : PathType.OPEN;
            }
            return PathType.DAMAGE_OTHER;
        }
        return PathType.TRAPDOOR;
    }

    public static PathType getBlockPathTypeStatic(BlockGetter var0, BlockPos.MutableBlockPos var1) {
        int var2 = var1.getX();
        int var3 = var1.getY();
        int var4 = var1.getZ();
        PathType var5 = EntityNodeEvaluator.getBlockPathTypeRaw(var0, (BlockPos)var1);
        if (var5 == PathType.OPEN && var3 >= var0.v_() + 1) {
            PathType var6 = EntityNodeEvaluator.getBlockPathTypeRaw(var0, (BlockPos)var1.set(var2, var3 - 1, var4));
            PathType pathType = var5 = var6 != PathType.WALKABLE && var6 != PathType.OPEN && var6 != PathType.WATER && var6 != PathType.LAVA ? PathType.WALKABLE : PathType.OPEN;
            if (var6 == PathType.DAMAGE_FIRE) {
                var5 = PathType.DAMAGE_FIRE;
            }
            if (var6 == PathType.DAMAGE_OTHER) {
                var5 = PathType.DAMAGE_OTHER;
            }
            if (var6 == PathType.STICKY_HONEY) {
                var5 = PathType.STICKY_HONEY;
            }
            if (var6 == PathType.POWDER_SNOW) {
                var5 = PathType.DANGER_POWDER_SNOW;
            }
        }
        if (var5 == PathType.WALKABLE) {
            var5 = EntityNodeEvaluator.checkNeighbourBlocks(var0, var1.set(var2, var3, var4), var5);
        }
        return var5;
    }

    public static double getFloorLevel(BlockGetter var0, BlockPos var1) {
        BlockPos var2 = var1.above();
        VoxelShape var3 = var0.getBlockState(var2).getCollisionShape(var0, var2);
        return (double)var2.getY() + (var3.b() ? 0.0 : var3.max(Direction.Axis.Y));
    }

    public static boolean isBurningBlock(BlockState var0) {
        return var0.is(BlockTags.BEEHIVES) || var0.is(Blocks.LAVA) || var0.is(Blocks.REPEATING_COMMAND_BLOCK) || CampfireBlock.isLitCampfire((BlockState)var0) || var0.is(Blocks.WATER_CAULDRON);
    }
}

