/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class PlayerAnimationImpl {
    private static Map<PlayerAnimation, Integer> DEFAULTS = Maps.newEnumMap(PlayerAnimation.class);

    public static void play(PlayerAnimation animation, Player bplayer, Iterable<Player> to) {
        ServerPlayer player = (ServerPlayer)NMSImpl.getHandle((Entity)bplayer);
        if (DEFAULTS.containsKey((Object)animation)) {
            PlayerAnimationImpl.playDefaultAnimation(player, to, DEFAULTS.get((Object)animation));
            return;
        }
        switch (animation) {
            case HURT: {
                PlayerAnimationImpl.sendPacketNearby(new ClientboundHurtAnimationPacket((LivingEntity)player), to);
                break;
            }
            case SNEAK: {
                player.setPose(Pose.CROUCHING);
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            case START_ELYTRA: {
                player.fP();
                break;
            }
            case STOP_ELYTRA: {
                player.fQ();
                break;
            }
            case START_USE_MAINHAND_ITEM: {
                player.startUsingItem(InteractionHand.MAIN_HAND);
                PlayerAnimationImpl.sendEntityData(to, player);
                player.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)player.fh()));
                break;
            }
            case START_USE_OFFHAND_ITEM: {
                player.startUsingItem(InteractionHand.OFF_HAND);
                PlayerAnimationImpl.sendEntityData(to, player);
                player.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)player.fh()));
                break;
            }
            case STOP_SNEAKING: {
                player.setPose(Pose.STANDING);
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            case STOP_USE_ITEM: {
                player.fk();
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static void playDefaultAnimation(ServerPlayer player, Iterable<Player> to, int code) {
        ClientboundAnimatePacket packet = new ClientboundAnimatePacket((net.minecraft.world.entity.Entity)player, code);
        PlayerAnimationImpl.sendPacketNearby(packet, to);
    }

    private static void sendEntityData(Iterable<Player> to, ServerPlayer player) {
        if (!player.aj().isDirty()) {
            return;
        }
        PlayerAnimationImpl.sendPacketNearby(new ClientboundSetEntityDataPacket(player.af(), player.aj().packDirty()), to);
    }

    protected static void sendPacketNearby(Packet<?> packet, Iterable<Player> to) {
        for (Player player : to) {
            NMSImpl.sendPacket(player, packet);
        }
    }

    static {
        DEFAULTS.put(PlayerAnimation.ARM_SWING, 0);
        DEFAULTS.put(PlayerAnimation.LEAVE_BED, 2);
        DEFAULTS.put(PlayerAnimation.ARM_SWING_OFFHAND, 3);
        DEFAULTS.put(PlayerAnimation.CRIT, 4);
        DEFAULTS.put(PlayerAnimation.MAGIC_CRIT, 5);
    }
}

