/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_20_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftDolphin;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.entity.Entity;

public class DolphinController
extends MobEntityController {
    public DolphinController() {
        super(EntityDolphinNPC.class);
    }

    public org.bukkit.entity.Dolphin getBukkitEntity() {
        return (org.bukkit.entity.Dolphin)super.getBukkitEntity();
    }

    public static class EntityDolphinNPC
    extends Dolphin
    implements NPCHolder {
        private boolean inProtectedTick;
        private final CitizensNPC npc;
        private MoveControl oldMoveController;

        public EntityDolphinNPC(EntityType<? extends Dolphin> types, Level level) {
            this(types, level, null);
        }

        public EntityDolphinNPC(EntityType<? extends Dolphin> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.oldMoveController = this.bP;
                this.bP = new MoveControl((Mob)this);
                this.getAttribute(Attributes.MAX_ABSORPTION).setBaseValue(this.getAttribute(Attributes.MAX_ABSORPTION).getBaseValue() / 10.0);
            }
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        protected boolean canRide(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof Boat || entity instanceof AbstractMinecart)) {
                return !this.npc.isProtected();
            }
            return super.canRide(entity);
        }

        public boolean causeFallDamage(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.causeFallDamage(f, f1, damagesource);
            }
            return false;
        }

        public void dB() {
            if (this.npc == null) {
                super.dB();
            }
        }

        protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.checkFallDamage(d0, flag, iblockdata, blockposition);
            }
        }

        protected SoundEvent getAmbientSound() {
            return NMSImpl.getSoundEffect(this.npc, super.getAmbientSound(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new DolphinNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEvent o_() {
            return NMSImpl.getSoundEffect(this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEvent getHurtSound(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getHurtSound(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float getWaterSlowDown() {
            return NMS.getJumpPower(this.npc, super.getWaterSlowDown());
        }

        public int getMaxFallDistance() {
            return NMS.getFallDistance(this.npc, super.getMaxFallDistance());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.k_();
        }

        public boolean isInWaterOrRain() {
            return this.inProtectedTick ? true : super.isInWaterOrRain();
        }

        public boolean gd() {
            return NMSImpl.isLeashed(this.npc, () -> super.gd(), (Mob)this);
        }

        public boolean isPickable() {
            return this.npc == null ? super.isPickable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void q(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.q((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AABB as() {
            return NMSBoundingBox.makeBB(this.npc, super.as());
        }

        public boolean q_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.q_();
            }
            return false;
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(ServerLevel worldserver, Vec3 location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void tick() {
            if (this.npc != null && this.npc.isProtected()) {
                this.inProtectedTick = true;
            }
            super.tick();
            this.inProtectedTick = false;
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (Mob)this);
                if (this.npc.useMinecraftAI() && this.bP != this.oldMoveController) {
                    this.bP = this.oldMoveController;
                    this.getAttribute(Attributes.MAX_ABSORPTION).setBaseValue(this.getAttribute(Attributes.MAX_ABSORPTION).getBaseValue() * 10.0);
                }
                if (!this.npc.useMinecraftAI() && this.bP == this.oldMoveController) {
                    this.bP = new MoveControl((Mob)this);
                    this.getAttribute(Attributes.MAX_ABSORPTION).setBaseValue(this.getAttribute(Attributes.MAX_ABSORPTION).getBaseValue() / 10.0);
                }
                this.npc.update();
            }
        }

        public void travel(Vec3 vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                if (!NMSImpl.moveFish(this.npc, (Mob)this, vec3d)) {
                    super.travel(vec3d);
                }
            } else {
                NMSImpl.flyingMoveLogic((LivingEntity)this, vec3d);
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.ds().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.push(old);
            }
            return res;
        }
    }

    public static class DolphinNPC
    extends CraftDolphin
    implements ForwardingNPCHolder {
        public DolphinNPC(EntityDolphinNPC entity) {
            super((CraftServer)Bukkit.getServer(), (Dolphin)entity);
        }
    }
}

