/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;

public class FallingBlockController
extends AbstractEntityController {
    public FallingBlockController() {
        super(EntityFallingBlockNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        ServerLevel ws = ((CraftWorld)at.getWorld()).getHandle();
        Block id = CraftMagicNumbers.getBlock((Material)npc.getItemProvider().get().getType());
        EntityFallingBlockNPC handle = new EntityFallingBlockNPC((EntityType<? extends FallingBlockEntity>)EntityType.FALLING_BLOCK, (Level)ws, npc);
        handle.setPos(at.getX(), at.getY(), at.getZ());
        handle.push(Vec3.ZERO);
        NMSImpl.setFallingBlockState(handle, id.defaultBlockState());
        return handle.getBukkitEntity();
    }

    public FallingBlock getBukkitEntity() {
        return (FallingBlock)super.getBukkitEntity();
    }

    public static class EntityFallingBlockNPC
    extends FallingBlockEntity
    implements NPCHolder {
        private final CitizensNPC npc;
        private static final double EPSILON = 0.001;

        public EntityFallingBlockNPC(EntityType<? extends FallingBlockEntity> types, Level level) {
            this(types, level, null);
        }

        public EntityFallingBlockNPC(EntityType<? extends FallingBlockEntity> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new FallingBlockNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.k_();
        }

        public boolean isPickable() {
            return this.npc == null ? super.isPickable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AABB as() {
            return NMSBoundingBox.makeBB(this.npc, super.as());
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void j_() {
            if (this.npc == null) {
                super.j_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.firstTick);
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(ServerLevel worldserver, Vec3 location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
                Vec3 mot = this.ds();
                if (Math.abs(mot.x) > 0.001 || Math.abs(mot.y) > 0.001 || Math.abs(mot.z) > 0.001) {
                    mot = mot.multiply(0.98, 0.98, 0.98);
                    this.push(mot);
                    this.move(MoverType.SELF, mot);
                }
            } else {
                super.tick();
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.ds().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.push(old);
            }
            return res;
        }
    }

    public static class FallingBlockNPC
    extends CraftFallingBlock
    implements NPCHolder {
        private final CitizensNPC npc;

        public FallingBlockNPC(EntityFallingBlockNPC entity) {
            super((CraftServer)Bukkit.getServer(), (FallingBlockEntity)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

